/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.autoconfigure.sql;

import com.microsoft.azure.spring.cloud.autoconfigure.context.AzureContextAutoConfiguration;
import com.microsoft.azure.spring.cloud.autoconfigure.sql.AzureSqlProperties;
import com.microsoft.azure.spring.cloud.autoconfigure.sql.JdbcDataSourcePropertiesUpdater;
import com.microsoft.azure.spring.cloud.autoconfigure.sql.SqlServerJdbcDataSourcePropertiesUpdater;
import com.microsoft.azure.spring.cloud.autoconfigure.telemetry.TelemetryTracker;
import com.microsoft.azure.spring.cloud.context.core.AzureAdmin;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.JndiDataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.XADataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;

@Configuration
@ConditionalOnClass(value={DataSource.class, EmbeddedDatabaseType.class})
@ConditionalOnProperty(name={"spring.cloud.azure.sql.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={AzureSqlProperties.class, DataSourceProperties.class})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class, JndiDataSourceAutoConfiguration.class, XADataSourceAutoConfiguration.class})
@AutoConfigureAfter(value={AzureContextAutoConfiguration.class})
public class AzureSqlAutoConfiguration {
    private static final String SQL_SERVER = "SqlServer";
    @Autowired(required=false)
    private TelemetryTracker telemetryTracker;

    @Configuration
    @Import(value={SqlServerJdbcInfoProviderConfiguration.class})
    class CloudSqlDataSourcePropertiesConfiguration {
        CloudSqlDataSourcePropertiesConfiguration() {
        }

        @Bean
        @Primary
        @ConditionalOnBean(value={JdbcDataSourcePropertiesUpdater.class})
        public DataSourceProperties cloudSqlDataSourceProperties(DataSourceProperties dataSourceProperties, JdbcDataSourcePropertiesUpdater dataSourcePropertiesProvider) {
            TelemetryTracker.triggerEvent(AzureSqlAutoConfiguration.this.telemetryTracker, AzureSqlAutoConfiguration.SQL_SERVER);
            dataSourcePropertiesProvider.updateDataSourceProperties(dataSourceProperties);
            return dataSourceProperties;
        }
    }

    @ConditionalOnClass(value={SQLServerDriver.class})
    @ConditionalOnMissingBean(value={JdbcDataSourcePropertiesUpdater.class})
    class SqlServerJdbcInfoProviderConfiguration {
        SqlServerJdbcInfoProviderConfiguration() {
        }

        @Bean
        public JdbcDataSourcePropertiesUpdater defaultSqlServerJdbcInfoProvider(AzureAdmin azureAdmin, AzureSqlProperties sqlProperties) {
            return new SqlServerJdbcDataSourcePropertiesUpdater(sqlProperties, azureAdmin);
        }
    }
}

