/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.autoconfigure.sql;

import com.microsoft.azure.spring.cloud.autoconfigure.sql.AzureSqlProperties;
import com.microsoft.azure.spring.cloud.autoconfigure.sql.DatabaseType;
import com.microsoft.azure.spring.cloud.autoconfigure.sql.JdbcDataSourcePropertiesUpdater;
import com.microsoft.azure.spring.cloud.context.core.AzureAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractJdbcDatasourcePropertiesUpdater
implements JdbcDataSourcePropertiesUpdater {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractJdbcDatasourcePropertiesUpdater.class);
    protected final DatabaseType databaseType;
    protected final AzureSqlProperties azureSqlProperties;
    protected final AzureAdmin azureAdmin;

    public AbstractJdbcDatasourcePropertiesUpdater(AzureSqlProperties azureSqlProperties, DatabaseType databaseType, AzureAdmin azureAdmin) {
        this.azureSqlProperties = azureSqlProperties;
        this.databaseType = databaseType;
        this.azureAdmin = azureAdmin;
        Assert.hasText((String)this.azureSqlProperties.getDatabaseName(), (String)"A database name must be provided.");
        Assert.hasText((String)this.azureSqlProperties.getServerName(), (String)"A database server must be provided.");
    }

    @Override
    public void updateDataSourceProperties(DataSourceProperties dataSourceProperties) {
        Assert.hasText((String)dataSourceProperties.getPassword(), (String)"spring.datasource.password must not be empty");
        if (StringUtils.isEmpty((Object)dataSourceProperties.getUsername())) {
            dataSourceProperties.setUsername(this.getUserName());
            LOGGER.info("spring.datasource.username is auto config into '{}'", (Object)this.getUserName());
        }
        if (StringUtils.isEmpty((Object)dataSourceProperties.getDriverClassName())) {
            dataSourceProperties.setDriverClassName(this.getDriverClass());
            LOGGER.info("spring.datasource.driverClassName is auto config into '{}'", (Object)this.getDriverClass());
        } else {
            LOGGER.warn("spring.datasource.driver-class-name is specified. Not using generated Cloud SQL configuration");
        }
        if (StringUtils.isEmpty((Object)dataSourceProperties.getUrl())) {
            dataSourceProperties.setUrl(this.getUrl(dataSourceProperties));
        } else {
            LOGGER.warn("spring.datasource.url is specified. Not using generated Cloud SQL configuration");
        }
    }

    String getDriverClass() {
        return this.databaseType.getJdbcDriverName();
    }

    abstract String getUserName();

    abstract String getUrl(DataSourceProperties var1);
}

