/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.autoconfigure.context;

import com.microsoft.azure.spring.cloud.context.core.CredentialSupplier;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(value="spring.cloud.azure")
public class AzureProperties
implements CredentialSupplier {
    private String credentialFilePath;
    private String resourceGroup;
    private String region;

    @PostConstruct
    public void validate() {
        Assert.hasText((String)this.credentialFilePath, (String)"spring.cloud.azure.credentialFilePath must be provided");
        Assert.hasText((String)this.resourceGroup, (String)"spring.cloud.azure.resourceGroup must be provided");
        Assert.hasText((String)this.region, (String)"spring.cloud.azure.region must be provided");
    }

    public String getCredentialFilePath() {
        return this.credentialFilePath;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public String getRegion() {
        return this.region;
    }

    public void setCredentialFilePath(String credentialFilePath) {
        this.credentialFilePath = credentialFilePath;
    }

    public void setResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
    }

    public void setRegion(String region) {
        this.region = region;
    }
}

