/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.autoconfigure.context;

import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.Azure;
import com.microsoft.azure.spring.cloud.autoconfigure.context.AzureProperties;
import com.microsoft.azure.spring.cloud.context.core.AzureAdmin;
import com.microsoft.azure.spring.cloud.context.core.AzureAopConfig;
import com.microsoft.azure.spring.cloud.context.core.CredentialSupplier;
import com.microsoft.azure.spring.cloud.context.core.CredentialsProvider;
import com.microsoft.azure.spring.cloud.context.core.DefaultCredentialsProvider;
import java.io.IOException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={AzureProperties.class})
@ConditionalOnClass(value={Azure.class})
@ConditionalOnProperty(value={"spring.cloud.azure.enabled"}, matchIfMissing=true)
@Import(value={AzureAopConfig.class})
public class AzureContextAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public CredentialsProvider credentialsProvider(AzureProperties azureProperties) {
        return new DefaultCredentialsProvider((CredentialSupplier)azureProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public AzureAdmin azureAdmin(Azure azure, AzureProperties azureProperties) {
        return new AzureAdmin(azure, azureProperties.getResourceGroup(), azureProperties.getRegion());
    }

    @Bean
    @ConditionalOnMissingBean
    public Azure azure(AzureProperties azureProperties) throws IOException {
        return Azure.authenticate((AzureTokenCredentials)this.credentialsProvider(azureProperties).getCredentials()).withDefaultSubscription();
    }
}

