/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.format;

import com.microsoft.azure.kusto.data.Ensure;
import com.microsoft.azure.kusto.data.StringUtils;
import com.microsoft.azure.kusto.data.format.CslFormat;
import com.microsoft.azure.kusto.data.format.CslStringFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CslDateTimeFormat
extends CslFormat {
    public static final String KUSTO_DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'";
    public static final String KUSTO_DATETIME_PATTERN_NO_FRACTIONS = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'").withZone(ZoneId.of("UTC"));
    Map<Integer, String> KUSTO_DATETIME_FORMATS = Stream.of({4, "yyyy"}, {6, "yyyyMM"}, {8, "yyyyMMdd"}, {10, "yyyyMMddHH"}, {12, "yyyyMMddHHmm"}, {14, "yyyyMMddHHmmss"}, {17, "yyyyMMdd HH:mm:ss"}, {19, "yyyyMMdd HH:mm:ss.f"}, {20, "yyyyMMdd HH:mm:ss.ff"}, {21, "yyyyMMdd HH:mm:ss.fff"}, {22, "yyyyMMdd HH:mm:ss.ffff"}, {23, "yyyyMMdd HH:mm:ss.fffff"}, {24, "yyyyMMdd HH:mm:ss.ffffff"}, {25, "yyyyMMdd HH:mm:ss.fffffff"}).collect(Collectors.toMap(data -> (Integer)data[0], data -> (String)data[1]));
    private final LocalDateTime value;

    public CslDateTimeFormat(LocalDateTime date) {
        this.value = date;
    }

    public CslDateTimeFormat(Date date) {
        this.value = date == null ? null : date.toInstant().atZone(ZoneId.of("UTC")).toLocalDateTime();
    }

    public CslDateTimeFormat(Long date) {
        this(date != null ? new Date(date) : null);
    }

    public CslDateTimeFormat(String localDateTimeString) {
        if (StringUtils.isBlank(localDateTimeString)) {
            this.value = null;
        } else {
            localDateTimeString = CslDateTimeFormat.parseValueFromValueWithType(localDateTimeString, this.getType()).trim();
            this.value = "null".equals(localDateTimeString = CslStringFormat.parseStringLiteral(localDateTimeString).trim()) ? null : ("min".equals(localDateTimeString) ? new Date(0L).toInstant().atZone(ZoneId.of("UTC")).toLocalDateTime() : ("max".equals(localDateTimeString) ? LocalDateTime.MAX : ("now".equalsIgnoreCase(localDateTimeString) ? Instant.now().atZone(ZoneId.of("UTC")).toLocalDateTime() : this.parseDateTimeFromString(localDateTimeString))));
        }
    }

    @Override
    public String getType() {
        return "datetime";
    }

    @Override
    public LocalDateTime getValue() {
        return this.value;
    }

    @Override
    String getValueAsString() {
        Ensure.argIsNotNull(this.value, "value");
        return this.value.format(DATE_TIME_FORMATTER);
    }

    private LocalDateTime parseDateTimeFromString(String localDateTimeString) {
        String formatMask = this.KUSTO_DATETIME_FORMATS.get(localDateTimeString.length());
        if (formatMask != null) {
            try {
                DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().appendPattern(formatMask).parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).toFormatter();
                return LocalDateTime.parse(localDateTimeString, dateTimeFormatter);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            TemporalAccessor ta = DateTimeFormatter.ISO_INSTANT.parse(localDateTimeString);
            Instant i = Instant.from(ta);
            return Date.from(i).toInstant().atZone(ZoneId.of("UTC")).toLocalDateTime();
        }
        catch (Exception ta) {
            try {
                DateTimeFormatter dateTimeFormatter = localDateTimeString.length() < 21 ? new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ofPattern(KUSTO_DATETIME_PATTERN_NO_FRACTIONS)).toFormatter() : new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ofPattern(KUSTO_DATETIME_PATTERN)).toFormatter();
                return LocalDateTime.parse(localDateTimeString, dateTimeFormatter);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

