/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.exceptions;

import com.microsoft.azure.kusto.data.Utils;
import com.microsoft.azure.kusto.data.exceptions.DataClientException;
import com.microsoft.azure.kusto.data.exceptions.DataServiceException;
import com.microsoft.azure.kusto.data.exceptions.IODataServiceException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;

public class ExceptionUtils {
    public static DataServiceException createExceptionOnPost(Exception e, URL url, String kind) {
        boolean permanent = false;
        boolean isIO = false;
        if (e instanceof IOException) {
            isIO = true;
        }
        if (e instanceof UncheckedIOException) {
            e = ((UncheckedIOException)e).getCause();
            isIO = true;
        }
        if (isIO) {
            return new IODataServiceException(url.toString(), (IOException)e, kind);
        }
        return new DataServiceException(url.toString(), String.format("Exception in %s post request: %s", kind, e.getMessage()), permanent);
    }

    public static String getMessageEx(Exception e) {
        return e.getMessage() == null && e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
    }

    public static Exception unwrapCloudInfoException(String clusterUrl, Throwable throwable) {
        DataServiceException e;
        IOException ex;
        if (throwable instanceof IOException && !Utils.isRetriableIOException(ex = (IOException)throwable)) {
            return new DataServiceException(clusterUrl, "IOException when trying to retrieve cluster metadata: " + ExceptionUtils.getMessageEx(ex), ex, Utils.isRetriableIOException(ex));
        }
        if (throwable instanceof DataServiceException && (e = (DataServiceException)((Object)throwable)).isPermanent()) {
            return e;
        }
        return new DataClientException(clusterUrl, throwable.toString(), null);
    }
}

