/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.kusto.data.Utils;
import com.microsoft.azure.kusto.data.auth.KeywordData;
import com.microsoft.azure.kusto.data.auth.KnownKeywords;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class KcsbKeywords {
    public KeywordData[] keywords;
    public String version;
    private final Map<String, KnownKeywords> lookup = new HashMap<String, KnownKeywords>();
    private static KcsbKeywords instance = null;
    private static final Object object = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KcsbKeywords getInstance() {
        if (instance != null) {
            return instance;
        }
        Object object = KcsbKeywords.object;
        synchronized (object) {
            if (instance == null) {
                instance = KcsbKeywords.readInstance();
            }
        }
        return instance;
    }

    public static String normalize(String keyword) {
        return keyword.toLowerCase().replace(" ", "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static KcsbKeywords readInstance() {
        try {
            ObjectMapper objectMapper = Utils.getObjectMapper();
            try (InputStream resourceAsStream = KcsbKeywords.class.getResourceAsStream("/kcsb.json");){
                KcsbKeywords value = (KcsbKeywords)objectMapper.readValue(resourceAsStream, KcsbKeywords.class);
                KeywordData[] object = value.keywords;
                int n = object.length;
                int n2 = 0;
                while (true) {
                    int n3;
                    String[] stringArray;
                    KnownKeywords keyword;
                    if (n2 < n) {
                        KeywordData keywordData = object[n2];
                        keyword = KnownKeywords.knownKeywords.get(keywordData.name);
                        if (keyword == null) {
                            throw new RuntimeException("Got unexpected keyword from embedded resource: `" + keywordData.name + "`. This is a bug in the SDK - please report it.");
                        }
                        keyword.setType(keywordData.type);
                        keyword.setSecret(keywordData.secret);
                        value.lookup.put(KcsbKeywords.normalize(keywordData.name), keyword);
                        stringArray = keywordData.aliases;
                        n3 = stringArray.length;
                    } else {
                        KcsbKeywords kcsbKeywords = value;
                        return kcsbKeywords;
                    }
                    for (int i = 0; i < n3; ++i) {
                        String alias = stringArray[i];
                        if (value.lookup.containsKey(alias)) {
                            throw new RuntimeException("KCSB keywordMap alias is duplicated: `" + alias + "`");
                        }
                        value.lookup.put(KcsbKeywords.normalize(alias), keyword);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to read kcsb.json", ex);
        }
    }

    public KnownKeywords get(String keyword) {
        KnownKeywords result = this.lookup.get(KcsbKeywords.normalize(keyword));
        if (result == null) {
            throw new IllegalArgumentException("The Connection String keyword `" + keyword + "` is unknown.");
        }
        if (!result.isSupported()) {
            throw new IllegalArgumentException("The Connection String keyword `" + keyword + "` is not supported by this SDK.");
        }
        return result;
    }
}

