/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.Header;
import com.microsoft.aad.msal4j.HttpRequest;
import com.microsoft.aad.msal4j.IHttpClient;
import com.microsoft.aad.msal4j.IHttpResponse;
import java.util.stream.Collectors;

public class HttpClientWrapper
implements IHttpClient {
    private final HttpClient httpClient;

    public HttpClientWrapper(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public IHttpResponse send(HttpRequest httpRequest) {
        HttpMethod method;
        switch (httpRequest.httpMethod()) {
            case GET: {
                method = HttpMethod.GET;
                break;
            }
            case POST: {
                method = HttpMethod.POST;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported HTTP method: " + httpRequest.httpMethod());
            }
        }
        com.azure.core.http.HttpRequest request = new com.azure.core.http.HttpRequest(method, httpRequest.url(), new HttpHeaders(httpRequest.headers()));
        if (!CoreUtils.isNullOrEmpty((CharSequence)httpRequest.body())) {
            request.setBody(httpRequest.body());
        }
        try (HttpResponse response = this.httpClient.sendSync(request, Context.NONE);){
            com.microsoft.aad.msal4j.HttpResponse msalResponse = new com.microsoft.aad.msal4j.HttpResponse();
            msalResponse.statusCode(response.getStatusCode());
            msalResponse.body(response.getBodyAsBinaryData().toString());
            msalResponse.addHeaders(response.getHeaders().stream().collect(Collectors.toMap(Header::getName, Header::getValuesList)));
            com.microsoft.aad.msal4j.HttpResponse httpResponse = msalResponse;
            return httpResponse;
        }
    }
}

