/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import com.microsoft.azure.kusto.data.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;

public class Ensure {
    public static void stringIsNotBlank(String str, String varName) {
        if (StringUtils.isBlank(str)) {
            throw new IllegalArgumentException(varName + " is blank.");
        }
    }

    public static void argIsNotNull(Object arg, String varName) {
        if (arg == null) {
            throw new IllegalArgumentException(varName + " is null.");
        }
    }

    public static void fileExists(File file, String argFile) throws FileNotFoundException {
        Ensure.argIsNotNull(file, argFile);
        if (!file.exists()) {
            throw new FileNotFoundException(argFile);
        }
    }

    public static void fileExists(String filePath) throws FileNotFoundException {
        Ensure.stringIsNotBlank(filePath, "filePath");
        File file = new File(filePath);
        Ensure.fileExists(file, filePath);
    }

    public static void isTrue(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException("Condition evaluated to false: " + message);
        }
    }

    public static void isFalse(boolean condition, String message) {
        if (condition) {
            throw new IllegalArgumentException("Condition evaluated to True: " + message);
        }
    }

    public static void stringIsNotEmpty(String str, String varName) {
        if (StringUtils.isEmpty(str)) {
            throw new IllegalArgumentException(varName + " is empty.");
        }
    }
}

