/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import com.microsoft.azure.kusto.data.StringUtils;
import com.microsoft.azure.kusto.data.UriUtils;
import com.microsoft.azure.kusto.data.Utils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

public class ClientDetails {
    public static final String NONE = "[none]";
    private static final ConcurrentHashMap<DefaultValues, String> defaultValues = new ConcurrentHashMap();
    private final String applicationForTracing;
    private final String userNameForTracing;
    private final String appendedClientVersionForTracing;

    public ClientDetails(String applicationForTracing, String userNameForTracing, String appendedClientVersionForTracing) {
        this.applicationForTracing = applicationForTracing;
        this.userNameForTracing = userNameForTracing;
        this.appendedClientVersionForTracing = appendedClientVersionForTracing;
    }

    private static String unpackLazy(DefaultValues key) {
        if (DefaultValues.DEFAULT_APPLICATION == key) {
            return defaultValues.computeIfAbsent(key, k -> UriUtils.stripFileNameFromCommandLine(System.getProperty("sun.java.command")));
        }
        if (DefaultValues.DEFAULT_USER == key) {
            return defaultValues.computeIfAbsent(key, k -> {
                String user = System.getProperty("user.name");
                if (StringUtils.isBlank(user)) {
                    user = System.getenv("USERNAME");
                    String domain = System.getenv("USERDOMAIN");
                    if (StringUtils.isNotBlank(domain) && StringUtils.isNotBlank(user)) {
                        user = domain + "\\" + user;
                    }
                }
                return StringUtils.isNotBlank(user) ? user : NONE;
            });
        }
        if (DefaultValues.DEFAULT_VERSION == key) {
            return defaultValues.computeIfAbsent(key, k -> {
                LinkedHashMap<String, String> baseMap = new LinkedHashMap<String, String>();
                baseMap.put("Kusto.Java.Client", Utils.getPackageVersion());
                baseMap.put(String.format("Runtime.%s", ClientDetails.escapeField(ClientDetails.getRuntime())), ClientDetails.getJavaVersion());
                return ClientDetails.formatHeader(baseMap);
            });
        }
        return NONE;
    }

    private static String formatHeader(Map<String, String> args) {
        return args.entrySet().stream().filter(arg -> StringUtils.isNotBlank((CharSequence)arg.getKey()) && StringUtils.isNotBlank((CharSequence)arg.getValue())).map(arg -> String.format("%s:%s", arg.getKey(), ClientDetails.escapeField((String)arg.getValue()))).collect(Collectors.joining("|"));
    }

    private static String escapeField(String field) {
        return String.format("{%s}", field.replaceAll("[\\r\\n\\s{}|]+", "_"));
    }

    public static ClientDetails fromConnectorDetails(String name, String version, boolean sendUser, @Nullable String overrideUser, @Nullable String appName, @Nullable String appVersion, Map<String, String> additionalFields) {
        LinkedHashMap<String, String> additionalFieldsMap = new LinkedHashMap<String, String>();
        additionalFieldsMap.put("Kusto." + name, version);
        if (appName == null) {
            appName = ClientDetails.unpackLazy(DefaultValues.DEFAULT_APPLICATION);
        }
        if (appVersion == null) {
            appVersion = NONE;
        }
        additionalFieldsMap.put(String.format("App.%s", ClientDetails.escapeField(appName)), appVersion);
        if (additionalFields != null) {
            additionalFieldsMap.putAll(additionalFields);
        }
        String app = ClientDetails.formatHeader(additionalFieldsMap);
        String user = NONE;
        if (sendUser) {
            user = overrideUser != null ? overrideUser : ClientDetails.unpackLazy(DefaultValues.DEFAULT_USER);
        }
        return new ClientDetails(app, user, null);
    }

    private static String getJavaVersion() {
        String version = System.getProperty("java.version");
        if (StringUtils.isBlank(version)) {
            return "UnknownVersion";
        }
        return version;
    }

    private static String getRuntime() {
        String runtime = System.getProperty("java.runtime.name");
        if (StringUtils.isBlank(runtime)) {
            runtime = System.getProperty("java.vm.name");
        }
        if (StringUtils.isBlank(runtime)) {
            runtime = System.getProperty("java.vendor");
        }
        if (StringUtils.isBlank(runtime)) {
            runtime = "UnknownRuntime";
        }
        return runtime;
    }

    public String getApplicationForTracing() {
        return this.applicationForTracing == null ? ClientDetails.unpackLazy(DefaultValues.DEFAULT_APPLICATION) : this.applicationForTracing;
    }

    public String getUserNameForTracing() {
        return this.userNameForTracing == null ? ClientDetails.unpackLazy(DefaultValues.DEFAULT_USER) : this.userNameForTracing;
    }

    public String getClientVersionForTracing() {
        return ClientDetails.unpackLazy(DefaultValues.DEFAULT_VERSION) + (this.appendedClientVersionForTracing == null ? "" : "|" + this.appendedClientVersionForTracing);
    }

    static enum DefaultValues {
        DEFAULT_APPLICATION("defaultApplication"),
        DEFAULT_USER("defaultUser"),
        DEFAULT_VERSION("defaultVersion");

        private final String value;

        private DefaultValues(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

