/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage.table;

import com.azure.core.util.paging.ContinuablePage;
import com.azure.data.tables.TableClient;
import com.azure.data.tables.TableServiceClient;
import com.azure.data.tables.TableServiceClientBuilder;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.common.model.AbstractEmulatableAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.page.ItemPage;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.storage.IStorageAccount;
import com.microsoft.azure.toolkit.lib.storage.table.Table;
import com.microsoft.azure.toolkit.lib.storage.table.TableDraft;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class TableModule
extends AbstractEmulatableAzResourceModule<Table, IStorageAccount, TableClient> {
    public static final String NAME = "Azure.Table";
    private TableServiceClient client;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public TableModule(@Nonnull IStorageAccount parent) {
        super(NAME, (AzResource)parent);
    }

    protected void invalidateCache() {
        super.invalidateCache();
        this.client = null;
    }

    @Nullable
    synchronized TableServiceClient getTableServiceClient() {
        if (Objects.isNull(this.client) && ((IStorageAccount)this.parent).exists()) {
            String connectionString = ((IStorageAccount)this.parent).getConnectionString();
            this.client = new TableServiceClientBuilder().addPolicy(AbstractAzServiceSubscription.getUserAgentPolicy()).connectionString(connectionString).buildClient();
        }
        return this.client;
    }

    @Nonnull
    protected Iterator<? extends ContinuablePage<String, TableClient>> loadResourcePagesFromAzure() {
        if (!((IStorageAccount)this.parent).exists()) {
            return Collections.emptyIterator();
        }
        TableServiceClient client = this.getTableServiceClient();
        return Objects.requireNonNull(client).listTables().streamByPage(TableModule.getPageSize()).map(p -> new ItemPage(p.getValue().stream().map(c -> client.getTableClient(c.getName())))).iterator();
    }

    @Nullable
    protected TableClient loadResourceFromAzure(@Nonnull String name, @Nullable String resourceGroup) {
        if (!((IStorageAccount)this.parent).exists()) {
            return null;
        }
        TableServiceClient client = this.getTableServiceClient();
        Stream<TableClient> resources = Objects.requireNonNull(client).listTables().stream().map(s -> client.getTableClient(s.getName()));
        return resources.filter(c -> c.getTableName().equals(name)).findAny().orElse(null);
    }

    @AzureOperation(name="azure/storage.delete_table.table", params={"nameFromResourceId(resourceId)"})
    protected void deleteResourceFromAzure(@Nonnull String resourceId) {
        String string = resourceId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ResourceId id = ResourceId.fromString((String)resourceId);
            TableServiceClient client = this.getTableServiceClient();
            Objects.requireNonNull(client).deleteTable(id.name());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    protected TableDraft newDraftForCreate(@Nonnull String name, @Nullable String resourceGroupName) {
        return new TableDraft(name, this);
    }

    @Nonnull
    protected Table newResource(@Nonnull TableClient r) {
        return new Table(r, this);
    }

    @Nonnull
    protected Table newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new Table(name, this);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Table";
    }

    static {
        TableModule.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TableModule.java", TableModule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "deleteResourceFromAzure", "com.microsoft.azure.toolkit.lib.storage.table.TableModule", "java.lang.String", "resourceId", "", "void"), 76);
    }
}

