/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage;

import com.microsoft.azure.toolkit.lib.common.model.AbstractConnectionStringAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.storage.ConnectionStringStorageAccount;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConnectionStringStorageAccountModule
extends AbstractConnectionStringAzResourceModule<ConnectionStringStorageAccount> {
    private static final String RESOURCE_ID = String.format("/subscriptions/%s/resourceGroups/%s/providers/Microsoft.Storage/storageAccounts/", CONNECTION_STRING_SUBSCRIPTION_ID, CONNECTION_STRING_RESOURCE_GROUP);
    private static ConnectionStringStorageAccountModule instance = null;

    protected ConnectionStringStorageAccountModule() {
        super("storageAccounts", AzResource.NONE);
    }

    public static synchronized ConnectionStringStorageAccountModule getInstance() {
        if (instance == null) {
            instance = new ConnectionStringStorageAccountModule();
        }
        return instance;
    }

    @Nonnull
    public String toResourceId(@Nonnull String resourceName, @Nullable String resourceGroup) {
        return RESOURCE_ID + resourceName;
    }

    @Nonnull
    protected ConnectionStringStorageAccount newResource(@Nonnull String s) {
        return new ConnectionStringStorageAccount(s);
    }

    public String getServiceNameForTelemetry() {
        return "storage";
    }
}

