/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage.model;

import com.google.common.collect.ImmutableList;
import com.microsoft.azure.toolkit.lib.common.model.ExpandableParameter;
import com.microsoft.azure.toolkit.lib.storage.model.Performance;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class Redundancy
implements ExpandableParameter {
    public static final Redundancy STANDARD_ZRS = new Redundancy(Performance.STANDARD, "Standard_ZRS", "Zone-Redundant");
    public static final Redundancy STANDARD_LRS = new Redundancy(Performance.STANDARD, "Standard_LRS", "Locally Redundant");
    public static final Redundancy STANDARD_GRS = new Redundancy(Performance.STANDARD, "Standard_GRS", "Geo-Redundant");
    public static final Redundancy STANDARD_RAGZRS = new Redundancy(Performance.STANDARD, "Standard_RAGZRS", "Read Access Geo-Zone-Redundant");
    public static final Redundancy PREMIUM_LRS = new Redundancy(Performance.PREMIUM, "Premium_LRS", "Locally Redundant");
    public static final Redundancy PREMIUM_ZRS = new Redundancy(Performance.PREMIUM, "Premium_ZRS", "Zone-Redundant");
    public static final Redundancy STANDARD_RAGRS = new Redundancy(Performance.STANDARD, "Standard_RAGRS", "Read Access Geo-Redundant");
    private static final List<Redundancy> values = new ImmutableList.Builder().add((Object[])new Redundancy[]{STANDARD_ZRS, STANDARD_LRS, STANDARD_GRS, STANDARD_RAGZRS, PREMIUM_LRS, PREMIUM_ZRS}).build();
    private final Performance performance;
    private final String name;
    private final String label;

    private Redundancy(Performance performance, String name, String label) {
        this.performance = performance;
        this.name = name;
        this.label = label;
    }

    public static List<Redundancy> values() {
        return values;
    }

    @Nonnull
    public static Redundancy fromName(@Nonnull String value) {
        return Redundancy.values().stream().filter(region -> StringUtils.equalsAnyIgnoreCase((CharSequence)value, (CharSequence[])new CharSequence[]{region.name, region.label})).findFirst().orElse(new Redundancy(Performance.STANDARD, value, value));
    }

    public boolean isExpandedValue() {
        return !Redundancy.values().contains(this);
    }

    public Performance getPerformance() {
        return this.performance;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Redundancy)) {
            return false;
        }
        Redundancy other = (Redundancy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Performance this$performance = this.getPerformance();
        Performance other$performance = other.getPerformance();
        if (this$performance == null ? other$performance != null : !((Object)this$performance).equals(other$performance)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        return !(this$label == null ? other$label != null : !this$label.equals(other$label));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Redundancy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Performance $performance = this.getPerformance();
        result = result * 59 + ($performance == null ? 43 : ((Object)$performance).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        return result;
    }
}

