/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerregistry;

import com.azure.containers.containerregistry.ContainerRepository;
import com.azure.containers.containerregistry.RegistryArtifact;
import com.azure.containers.containerregistry.models.ArtifactTagProperties;
import com.azure.core.util.paging.ContinuablePage;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.page.ItemPage;
import com.microsoft.azure.toolkit.lib.containerregistry.Artifact;
import com.microsoft.azure.toolkit.lib.containerregistry.Repository;
import com.microsoft.azure.toolkit.lib.containerregistry.Tag;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;

public class TagModule
extends AbstractAzResourceModule<Tag, Artifact, ArtifactTagProperties> {
    public static final String NAME = "tags";

    public TagModule(@Nonnull Artifact parent) {
        super(NAME, (AzResource)parent);
    }

    @Nonnull
    protected Iterator<? extends ContinuablePage<String, ArtifactTagProperties>> loadResourcePagesFromAzure() {
        List tags = Optional.of((Artifact)this.getParent()).filter(AbstractAzResource::exists).map(Artifact::getTags).orElse(Collections.emptyList());
        if (CollectionUtils.isEmpty(tags)) {
            return Collections.emptyIterator();
        }
        Repository repository = (Repository)((Artifact)this.getParent()).getParent();
        RegistryArtifact image = Objects.requireNonNull((ContainerRepository)repository.getRemote()).getArtifact(((Artifact)this.getParent()).getDigest());
        return Collections.singletonList(new ItemPage(tags.stream().map(arg_0 -> ((RegistryArtifact)image).getTagProperties(arg_0)))).iterator();
    }

    @Nullable
    protected ArtifactTagProperties loadResourceFromAzure(@Nonnull String name, String unused) {
        if (!((Artifact)this.parent).exists()) {
            return null;
        }
        RegistryArtifact artifact = Objects.requireNonNull((ContainerRepository)((Repository)((Artifact)this.parent).getParent()).getRemote()).getArtifact(((Artifact)this.getParent()).getDigest());
        return artifact.getTagProperties(name);
    }

    protected void deleteResourceFromAzure(@Nonnull String resourceId) {
        Tag tag = (Tag)this.get(resourceId);
        Optional.ofNullable(tag).map(AbstractAzResource::getParent).map(Artifact::getArtifact).ifPresent(a -> a.deleteTag(tag.getName()));
    }

    @Nonnull
    protected Tag newResource(@Nonnull ArtifactTagProperties tag) {
        return new Tag(tag.getName(), this);
    }

    @Nonnull
    protected Tag newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new Tag(name, this);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Tag";
    }
}

