/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerregistry;

import com.azure.containers.containerregistry.ContainerRepository;
import com.azure.containers.containerregistry.models.ContainerRepositoryProperties;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.account.IAccount;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.containerregistry.ArtifactModule;
import com.microsoft.azure.toolkit.lib.containerregistry.ContainerRegistry;
import com.microsoft.azure.toolkit.lib.containerregistry.RepositoryModule;
import java.net.URLEncoder;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class Repository
extends AbstractAzResource<Repository, ContainerRegistry, ContainerRepository>
implements Deletable {
    private final ArtifactModule artifactModule;
    @Nullable
    private ContainerRepositoryProperties properties;

    protected Repository(@Nonnull String name, @Nonnull RepositoryModule module) {
        super(name, (AbstractAzResourceModule)module);
        this.artifactModule = new ArtifactModule(this);
    }

    protected Repository(@Nonnull Repository registry) {
        super((AbstractAzResource)registry);
        this.artifactModule = registry.artifactModule;
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.singletonList(this.artifactModule);
    }

    @Nonnull
    protected String loadStatus(@Nonnull ContainerRepository remote) {
        return "OK";
    }

    protected void updateAdditionalProperties(@Nullable ContainerRepository newRemote, @Nullable ContainerRepository oldRemote) {
        super.updateAdditionalProperties((Object)newRemote, (Object)oldRemote);
        this.properties = Optional.ofNullable(newRemote).map(ContainerRepository::getProperties).orElse(null);
    }

    public OffsetDateTime getLastUpdatedOn() {
        return Optional.ofNullable(this.properties).map(ContainerRepositoryProperties::getLastUpdatedOn).orElse(OffsetDateTime.MIN);
    }

    @Nonnull
    public String getPortalUrl() {
        IAccount account = ((IAzureAccount)Azure.az(IAzureAccount.class)).account();
        String encodedRegistryId = URLEncoder.encode(((ContainerRegistry)this.getParent()).getId(), "UTF-8");
        String encodedRepositoryName = URLEncoder.encode(this.getName(), "UTF-8");
        return String.format("%s/#blade/Microsoft_Azure_ContainerRegistries/RepositoryBlade/id/%s/repository/%s", account.getPortalUrl(), encodedRegistryId, encodedRepositoryName);
    }

    public String getFullName() {
        ContainerRegistry registry = (ContainerRegistry)this.getParent();
        return String.format("%s/%s", registry.getLoginServerUrl(), this.getName());
    }

    @Generated
    public ArtifactModule getArtifactModule() {
        return this.artifactModule;
    }
}

