/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerregistry;

import com.azure.resourcemanager.containerregistry.models.RegistryTaskRun;
import com.microsoft.azure.toolkit.lib.common.utils.StreamingLogSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public class RegistryTaskRunStreamingLog
implements StreamingLogSupport {
    private static final int RETRY_INTERVAL = 1000;
    private static final int WAIT_INTERVAL = 500;
    private RegistryTaskRun task;
    private String logSasUrl;

    @NotNull
    public String getDisplayName() {
        return this.task.runId();
    }

    @NotNull
    public String getId() {
        return this.task.runId();
    }

    public Flux<String> streamingLogs(boolean follow, @NotNull Map<String, String> p) {
        return Flux.create(sink -> {
            String content = "";
            try {
                int i = 0;
                while (true) {
                    String newContent;
                    if (StringUtils.equals((CharSequence)(newContent = StringUtils.substringBeforeLast((String)RegistryTaskRunStreamingLog.readFromUrl(this.logSasUrl), (String)"\n")), (CharSequence)content)) {
                        Thread.sleep(1000 * ++i);
                        continue;
                    }
                    Arrays.stream(StringUtils.removeStart((String)newContent, (String)content).split("\n")).forEach(arg_0 -> ((FluxSink)sink).next(arg_0));
                    content = newContent;
                    i = 0;
                    Thread.sleep(500L);
                }
            }
            catch (Exception e) {
                sink.error((Throwable)e);
                return;
            }
        });
    }

    public static String readFromUrl(String urlString) throws IOException {
        URL url = new URL(urlString);
        URLConnection conn = url.openConnection();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    @Generated
    public static RegistryTaskRunStreamingLogBuilder builder() {
        return new RegistryTaskRunStreamingLogBuilder();
    }

    @Generated
    public RegistryTaskRun getTask() {
        return this.task;
    }

    @Generated
    public String getLogSasUrl() {
        return this.logSasUrl;
    }

    @Generated
    public RegistryTaskRunStreamingLog() {
    }

    @Generated
    public RegistryTaskRunStreamingLog(RegistryTaskRun task, String logSasUrl) {
        this.task = task;
        this.logSasUrl = logSasUrl;
    }

    @Generated
    public static class RegistryTaskRunStreamingLogBuilder {
        @Generated
        private RegistryTaskRun task;
        @Generated
        private String logSasUrl;

        @Generated
        RegistryTaskRunStreamingLogBuilder() {
        }

        @Generated
        public RegistryTaskRunStreamingLogBuilder task(RegistryTaskRun task) {
            this.task = task;
            return this;
        }

        @Generated
        public RegistryTaskRunStreamingLogBuilder logSasUrl(String logSasUrl) {
            this.logSasUrl = logSasUrl;
            return this;
        }

        @Generated
        public RegistryTaskRunStreamingLog build() {
            return new RegistryTaskRunStreamingLog(this.task, this.logSasUrl);
        }

        @Generated
        public String toString() {
            return "RegistryTaskRunStreamingLog.RegistryTaskRunStreamingLogBuilder(task=" + this.task + ", logSasUrl=" + this.logSasUrl + ")";
        }
    }
}

