/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerregistry;

import com.azure.resourcemanager.containerregistry.models.Registries;
import com.azure.resourcemanager.containerregistry.models.Registry;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.containerregistry.AzureContainerRegistryModule;
import com.microsoft.azure.toolkit.lib.containerregistry.AzureContainerRegistryServiceSubscription;
import com.microsoft.azure.toolkit.lib.containerregistry.ContainerRegistry;
import com.microsoft.azure.toolkit.lib.containerregistry.model.Sku;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ContainerRegistryDraft
extends ContainerRegistry
implements AzResource.Draft<ContainerRegistry, Registry> {
    private static final String REGION_AND_SKU_IS_REQUIRED = "`region` and `sku` is required to create a container registry in Azure";
    @Nullable
    private Region region;
    @Nullable
    private Sku sku;
    @Nullable
    private Boolean adminUserEnabled;
    @Nullable
    private Boolean publicAccessEnabled;
    @Nullable
    private final ContainerRegistry origin;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    protected ContainerRegistryDraft(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull AzureContainerRegistryModule module) {
        super(name, resourceGroupName, module);
        this.origin = null;
    }

    public ContainerRegistryDraft(@Nonnull ContainerRegistry origin) {
        super(origin);
        this.origin = origin;
    }

    public void reset() {
        this.region = null;
        this.sku = null;
        this.adminUserEnabled = null;
        this.publicAccessEnabled = null;
    }

    @Nonnull
    @AzureOperation(name="azure/acr.create_registry.registry", params={"this.getName()"})
    public Registry createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            Registry.DefinitionStages.WithCreate withCreate;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            if (ObjectUtils.anyNull((Object[])new Object[]{this.region, this.sku})) {
                throw new AzureToolkitRuntimeException(REGION_AND_SKU_IS_REQUIRED);
            }
            Registries registries = Objects.requireNonNull(((AzureContainerRegistryServiceSubscription)this.getParent()).getAzureContainerRegistryModule().getClient());
            Registry.DefinitionStages.WithSku withSku = (Registry.DefinitionStages.WithSku)((Registry.DefinitionStages.WithGroup)((Registry.DefinitionStages.Blank)registries.define(this.getName())).withRegion(this.region.getName())).withExistingResourceGroup(this.getResourceGroupName());
            if (this.sku == Sku.Basic) {
                withCreate = withSku.withBasicSku();
            } else if (this.sku == Sku.Standard) {
                withCreate = withSku.withStandardSku();
            } else if (this.sku == Sku.Premium) {
                withCreate = withSku.withPremiumSku();
            } else {
                throw new AzureToolkitRuntimeException(String.format("Invalid sku, valid values are %s", StringUtils.join((Object[])Sku.values(), (String)",")));
            }
            if (this.isAdminUserEnabled()) {
                withCreate.withRegistryNameAsAdminUser();
            }
            if (!this.isPublicAccessEnabled()) {
                withCreate.disablePublicNetworkAccess();
            }
            AzureMessager.getMessager().info(AzureString.format((String)"Start creating Container Registry ({0})", (Object[])new Object[]{this.getName()}));
            Registry registry = (Registry)withCreate.create();
            AzureMessager.getMessager().success(AzureString.format((String)"Container Registry ({0}) is successfully created", (Object[])new Object[]{this.getName()}));
            Registry registry2 = registry;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return registry2;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="azure/acr.update_registry.registry", params={"this.getName()"})
    public Registry updateResourceInAzure(@Nonnull Registry origin) {
        Registry registry = origin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)registry);
        try {
            Registry registry2;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            if (!this.isModified()) {
                registry2 = origin;
            } else {
                Registry.Update update = (Registry.Update)origin.update();
                if (this.sku != null) {
                    if (this.sku == Sku.Basic) {
                        update.withBasicSku();
                    } else if (this.sku == Sku.Standard) {
                        update.withStandardSku();
                    } else if (this.sku == Sku.Premium) {
                        update.withPremiumSku();
                    } else {
                        throw new AzureToolkitRuntimeException(String.format("Invalid sku, valid values are %s", StringUtils.join((Object[])Sku.values(), (String)",")));
                    }
                }
                if (this.isAdminUserEnabled()) {
                    update.withRegistryNameAsAdminUser();
                } else {
                    update.withoutRegistryNameAsAdminUser();
                }
                if (this.isPublicAccessEnabled()) {
                    update.enablePublicNetworkAccess();
                } else {
                    update.disablePublicNetworkAccess();
                }
                registry2 = (Registry)update.apply();
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return registry2;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    public boolean isModified() {
        if (this.origin == null) {
            return ObjectUtils.anyNotNull((Object[])new Object[]{this.region, this.sku, this.publicAccessEnabled, this.adminUserEnabled});
        }
        return !Objects.equals(this.getRegion(), this.origin.getRegion()) || !Objects.equals((Object)this.getSku(), (Object)this.origin.getSku()) || !Objects.equals(this.isPublicAccessEnabled(), this.origin.isPublicAccessEnabled()) || !Objects.equals(this.isAdminUserEnabled(), this.origin.isAdminUserEnabled());
    }

    @Nullable
    public ContainerRegistry getOrigin() {
        return this.origin;
    }

    @Override
    @Nullable
    public Region getRegion() {
        return Optional.ofNullable(this.region).orElseGet(() -> Optional.ofNullable(this.origin).map(ContainerRegistry::getRegion).orElse(null));
    }

    @Override
    @Nullable
    public Sku getSku() {
        return Optional.ofNullable(this.sku).orElseGet(() -> Optional.ofNullable(this.origin).map(ContainerRegistry::getSku).orElse(null));
    }

    @Override
    public boolean isAdminUserEnabled() {
        return Optional.ofNullable(this.adminUserEnabled).orElseGet(() -> super.isAdminUserEnabled());
    }

    @Override
    public boolean isPublicAccessEnabled() {
        return Optional.ofNullable(this.publicAccessEnabled).orElseGet(() -> super.isPublicAccessEnabled());
    }

    @Generated
    public void setRegion(@Nullable Region region) {
        this.region = region;
    }

    @Generated
    public void setSku(@Nullable Sku sku) {
        this.sku = sku;
    }

    @Generated
    public void setAdminUserEnabled(@Nullable Boolean adminUserEnabled) {
        this.adminUserEnabled = adminUserEnabled;
    }

    @Generated
    public void setPublicAccessEnabled(@Nullable Boolean publicAccessEnabled) {
        this.publicAccessEnabled = publicAccessEnabled;
    }

    static {
        ContainerRegistryDraft.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ContainerRegistryDraft.java", ContainerRegistryDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.containerregistry.ContainerRegistryDraft", "", "", "", "com.azure.resourcemanager.containerregistry.models.Registry"), 71);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.containerregistry.ContainerRegistryDraft", "com.azure.resourcemanager.containerregistry.models.Registry", "origin", "", "com.azure.resourcemanager.containerregistry.models.Registry"), 104);
    }
}

