/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerregistry;

import com.azure.containers.containerregistry.ContainerRepository;
import com.azure.containers.containerregistry.RegistryArtifact;
import com.azure.containers.containerregistry.models.ArtifactManifestProperties;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.containerregistry.ArtifactModule;
import com.microsoft.azure.toolkit.lib.containerregistry.Repository;
import com.microsoft.azure.toolkit.lib.containerregistry.TagModule;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class Artifact
extends AbstractAzResource<Artifact, Repository, ArtifactManifestProperties>
implements Deletable {
    private final TagModule tagModule;
    @Nullable
    private RegistryArtifact artifact;

    protected Artifact(@Nonnull String name, @Nonnull ArtifactModule module) {
        super(name, (AbstractAzResourceModule)module);
        this.tagModule = new TagModule(this);
    }

    protected Artifact(@Nonnull Artifact artifact) {
        super((AbstractAzResource)artifact);
        this.tagModule = artifact.tagModule;
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.singletonList(this.tagModule);
    }

    @Nonnull
    protected String loadStatus(@Nonnull ArtifactManifestProperties remote) {
        return "OK";
    }

    protected void updateAdditionalProperties(@Nullable ArtifactManifestProperties newRemote, @Nullable ArtifactManifestProperties oldRemote) {
        if (Objects.nonNull(newRemote)) {
            ContainerRepository repository = Objects.requireNonNull((ContainerRepository)((Repository)this.getParent()).getRemote());
            this.artifact = repository.getArtifact(newRemote.getDigest());
        } else {
            this.artifact = null;
        }
    }

    @Nonnull
    public String getDigest() {
        return this.remoteOptional().map(ArtifactManifestProperties::getDigest).orElse("");
    }

    public long getSize() {
        return this.remoteOptional().map(ArtifactManifestProperties::getSizeInBytes).orElse(0L);
    }

    public List<String> getTags() {
        return this.remoteOptional().map(ArtifactManifestProperties::getTags).orElse(Collections.emptyList());
    }

    @Nonnull
    public OffsetDateTime getLastUpdateDate() {
        return this.remoteOptional().map(ArtifactManifestProperties::getLastUpdatedOn).orElse(OffsetDateTime.MIN);
    }

    @Generated
    public TagModule getTagModule() {
        return this.tagModule;
    }

    @Nullable
    @Generated
    RegistryArtifact getArtifact() {
        return this.artifact;
    }
}

