/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerapps.model;

import com.azure.resourcemanager.appcontainers.models.Ingress;
import com.azure.resourcemanager.appcontainers.models.IngressTransportMethod;
import com.azure.resourcemanager.appcontainers.models.TrafficWeight;
import com.microsoft.azure.toolkit.lib.containerapps.model.TransportMethod;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.BooleanUtils;

public class IngressConfig {
    public static final Traffic DEFAULT_TRAFFIC = Traffic.builder().latestRevision(true).weight(100).build();
    private boolean enableIngress;
    private int targetPort;
    private boolean external;
    private boolean allowInsecure;
    private TransportMethod transport;
    private List<Traffic> traffic;

    public static IngressConfig fromIngress(@Nullable Ingress ingress) {
        if (ingress == null) {
            return IngressConfig.builder().enableIngress(false).build();
        }
        List trafficList = Optional.ofNullable(ingress.traffic()).map(weight -> weight.stream().map(Traffic::fromTrafficWeight).collect(Collectors.toList())).orElse(null);
        TransportMethod transportMethod = Optional.ofNullable(ingress.transport()).map(method -> TransportMethod.fromString(method.toString())).orElse(null);
        return IngressConfig.builder().enableIngress(true).allowInsecure(ingress.allowInsecure()).external(ingress.external()).targetPort(ingress.targetPort()).traffic(trafficList).transport(transportMethod).build();
    }

    @Nullable
    public Ingress toIngress() {
        if (!this.isEnableIngress()) {
            return null;
        }
        List trafficList = Optional.ofNullable(this.traffic).map(weight -> weight.stream().map(Traffic::toTrafficWeight).collect(Collectors.toList())).orElse(null);
        IngressTransportMethod transportMethod = Optional.ofNullable(this.getTransport()).map(method -> IngressTransportMethod.fromString((String)method.getValue())).orElse(null);
        return new Ingress().withAllowInsecure(Boolean.valueOf(this.isAllowInsecure())).withExternal(Boolean.valueOf(this.isExternal())).withTargetPort(Integer.valueOf(this.getTargetPort())).withTraffic(trafficList).withTransport(transportMethod);
    }

    private static boolean $default$allowInsecure() {
        return false;
    }

    private static TransportMethod $default$transport() {
        return TransportMethod.AUTO;
    }

    private static List<Traffic> $default$traffic() {
        return Arrays.asList(DEFAULT_TRAFFIC);
    }

    public static IngressConfigBuilder builder() {
        return new IngressConfigBuilder();
    }

    public boolean isEnableIngress() {
        return this.enableIngress;
    }

    public int getTargetPort() {
        return this.targetPort;
    }

    public boolean isExternal() {
        return this.external;
    }

    public boolean isAllowInsecure() {
        return this.allowInsecure;
    }

    public TransportMethod getTransport() {
        return this.transport;
    }

    public List<Traffic> getTraffic() {
        return this.traffic;
    }

    public void setEnableIngress(boolean enableIngress) {
        this.enableIngress = enableIngress;
    }

    public void setTargetPort(int targetPort) {
        this.targetPort = targetPort;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public void setAllowInsecure(boolean allowInsecure) {
        this.allowInsecure = allowInsecure;
    }

    public void setTransport(TransportMethod transport) {
        this.transport = transport;
    }

    public void setTraffic(List<Traffic> traffic) {
        this.traffic = traffic;
    }

    public String toString() {
        return "IngressConfig(enableIngress=" + this.isEnableIngress() + ", targetPort=" + this.getTargetPort() + ", external=" + this.isExternal() + ", allowInsecure=" + this.isAllowInsecure() + ", transport=" + this.getTransport() + ", traffic=" + this.getTraffic() + ")";
    }

    public IngressConfig() {
        this.allowInsecure = IngressConfig.$default$allowInsecure();
        this.transport = IngressConfig.$default$transport();
        this.traffic = IngressConfig.$default$traffic();
    }

    public IngressConfig(boolean enableIngress, int targetPort, boolean external, boolean allowInsecure, TransportMethod transport, List<Traffic> traffic) {
        this.enableIngress = enableIngress;
        this.targetPort = targetPort;
        this.external = external;
        this.allowInsecure = allowInsecure;
        this.transport = transport;
        this.traffic = traffic;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IngressConfig)) {
            return false;
        }
        IngressConfig other = (IngressConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnableIngress() != other.isEnableIngress()) {
            return false;
        }
        if (this.getTargetPort() != other.getTargetPort()) {
            return false;
        }
        if (this.isExternal() != other.isExternal()) {
            return false;
        }
        if (this.isAllowInsecure() != other.isAllowInsecure()) {
            return false;
        }
        TransportMethod this$transport = this.getTransport();
        TransportMethod other$transport = other.getTransport();
        if (this$transport == null ? other$transport != null : !((Object)this$transport).equals(other$transport)) {
            return false;
        }
        List<Traffic> this$traffic = this.getTraffic();
        List<Traffic> other$traffic = other.getTraffic();
        return !(this$traffic == null ? other$traffic != null : !((Object)this$traffic).equals(other$traffic));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IngressConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnableIngress() ? 79 : 97);
        result = result * 59 + this.getTargetPort();
        result = result * 59 + (this.isExternal() ? 79 : 97);
        result = result * 59 + (this.isAllowInsecure() ? 79 : 97);
        TransportMethod $transport = this.getTransport();
        result = result * 59 + ($transport == null ? 43 : ((Object)$transport).hashCode());
        List<Traffic> $traffic = this.getTraffic();
        result = result * 59 + ($traffic == null ? 43 : ((Object)$traffic).hashCode());
        return result;
    }

    public static class IngressConfigBuilder {
        private boolean enableIngress;
        private int targetPort;
        private boolean external;
        private boolean allowInsecure$set;
        private boolean allowInsecure$value;
        private boolean transport$set;
        private TransportMethod transport$value;
        private boolean traffic$set;
        private List<Traffic> traffic$value;

        IngressConfigBuilder() {
        }

        public IngressConfigBuilder enableIngress(boolean enableIngress) {
            this.enableIngress = enableIngress;
            return this;
        }

        public IngressConfigBuilder targetPort(int targetPort) {
            this.targetPort = targetPort;
            return this;
        }

        public IngressConfigBuilder external(boolean external) {
            this.external = external;
            return this;
        }

        public IngressConfigBuilder allowInsecure(boolean allowInsecure) {
            this.allowInsecure$value = allowInsecure;
            this.allowInsecure$set = true;
            return this;
        }

        public IngressConfigBuilder transport(TransportMethod transport) {
            this.transport$value = transport;
            this.transport$set = true;
            return this;
        }

        public IngressConfigBuilder traffic(List<Traffic> traffic) {
            this.traffic$value = traffic;
            this.traffic$set = true;
            return this;
        }

        public IngressConfig build() {
            boolean allowInsecure$value = this.allowInsecure$value;
            if (!this.allowInsecure$set) {
                allowInsecure$value = IngressConfig.$default$allowInsecure();
            }
            TransportMethod transport$value = this.transport$value;
            if (!this.transport$set) {
                transport$value = IngressConfig.$default$transport();
            }
            List traffic$value = this.traffic$value;
            if (!this.traffic$set) {
                traffic$value = IngressConfig.$default$traffic();
            }
            return new IngressConfig(this.enableIngress, this.targetPort, this.external, allowInsecure$value, transport$value, traffic$value);
        }

        public String toString() {
            return "IngressConfig.IngressConfigBuilder(enableIngress=" + this.enableIngress + ", targetPort=" + this.targetPort + ", external=" + this.external + ", allowInsecure$value=" + this.allowInsecure$value + ", transport$value=" + this.transport$value + ", traffic$value=" + this.traffic$value + ")";
        }
    }

    public static class Traffic {
        private int weight;
        private boolean latestRevision;

        public static Traffic fromTrafficWeight(@Nonnull TrafficWeight trafficWeight) {
            return Traffic.builder().weight(trafficWeight.weight()).latestRevision(BooleanUtils.isTrue((Boolean)trafficWeight.latestRevision())).build();
        }

        public TrafficWeight toTrafficWeight() {
            return new TrafficWeight().withWeight(Integer.valueOf(this.weight)).withLatestRevision(Boolean.valueOf(this.latestRevision));
        }

        public static TrafficBuilder builder() {
            return new TrafficBuilder();
        }

        public int getWeight() {
            return this.weight;
        }

        public boolean isLatestRevision() {
            return this.latestRevision;
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }

        public void setLatestRevision(boolean latestRevision) {
            this.latestRevision = latestRevision;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Traffic)) {
                return false;
            }
            Traffic other = (Traffic)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getWeight() != other.getWeight()) {
                return false;
            }
            return this.isLatestRevision() == other.isLatestRevision();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Traffic;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getWeight();
            result = result * 59 + (this.isLatestRevision() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "IngressConfig.Traffic(weight=" + this.getWeight() + ", latestRevision=" + this.isLatestRevision() + ")";
        }

        public Traffic() {
        }

        public Traffic(int weight, boolean latestRevision) {
            this.weight = weight;
            this.latestRevision = latestRevision;
        }

        public static class TrafficBuilder {
            private int weight;
            private boolean latestRevision;

            TrafficBuilder() {
            }

            public TrafficBuilder weight(int weight) {
                this.weight = weight;
                return this;
            }

            public TrafficBuilder latestRevision(boolean latestRevision) {
                this.latestRevision = latestRevision;
                return this;
            }

            public Traffic build() {
                return new Traffic(this.weight, this.latestRevision);
            }

            public String toString() {
                return "IngressConfig.Traffic.TrafficBuilder(weight=" + this.weight + ", latestRevision=" + this.latestRevision + ")";
            }
        }
    }
}

