/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerapps.environment;

import com.azure.core.util.paging.ContinuablePage;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironment;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironments;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.containerapps.AzureContainerAppsServiceSubscription;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironment;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironmentDraft;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ContainerAppsEnvironmentModule
extends AbstractAzResourceModule<ContainerAppsEnvironment, AzureContainerAppsServiceSubscription, ManagedEnvironment> {
    public static final String NAME = "managedEnvironments";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public ContainerAppsEnvironmentModule(@Nonnull AzureContainerAppsServiceSubscription parent) {
        super(NAME, (AzResource)parent);
    }

    @Nonnull
    protected Iterator<? extends ContinuablePage<String, ManagedEnvironment>> loadResourcePagesFromAzure() {
        return Optional.ofNullable(this.getClient()).map(c -> c.list().iterableByPage(ContainerAppsEnvironmentModule.getPageSize()).iterator()).orElse(Collections.emptyIterator());
    }

    @Nullable
    @AzureOperation(name="azure/containerapps.load_environment.env", params={"name"})
    protected ManagedEnvironment loadResourceFromAzure(@Nonnull String name, @Nullable String resourceGroup) {
        String string = name;
        String string2 = resourceGroup;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ManagedEnvironment managedEnvironment = Optional.ofNullable(this.getClient()).map(client -> client.getByResourceGroup(resourceGroup, name)).orElse(null);
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return managedEnvironment;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @AzureOperation(name="azure/containerapps.delete_environment.env", params={"nameFromResourceId(resourceId)"})
    protected void deleteResourceFromAzure(@Nonnull String resourceId) {
        String string = resourceId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ResourceId id = ResourceId.fromString((String)resourceId);
            Optional.ofNullable(this.getClient()).ifPresent(client -> client.deleteByResourceGroup(id.resourceGroupName(), id.name()));
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    protected ContainerAppsEnvironmentDraft newDraftForCreate(@Nonnull String name, @Nullable String rgName) {
        assert (rgName != null) : "'Resource group' is required.";
        return new ContainerAppsEnvironmentDraft(name, rgName, this);
    }

    @Nonnull
    protected ContainerAppsEnvironmentDraft newDraftForUpdate(@Nonnull ContainerAppsEnvironment environment) {
        throw new UnsupportedOperationException("not support");
    }

    @Nonnull
    protected ContainerAppsEnvironment newResource(@Nonnull ManagedEnvironment environment) {
        return new ContainerAppsEnvironment(environment, this);
    }

    @Nonnull
    protected ContainerAppsEnvironment newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        assert (resourceGroupName != null) : "'Resource group' is required.";
        return new ContainerAppsEnvironment(name, resourceGroupName, this);
    }

    @Nullable
    public ManagedEnvironments getClient() {
        return Optional.ofNullable(((AzureContainerAppsServiceSubscription)this.parent).getRemote()).map(ContainerAppsApiManager::managedEnvironments).orElse(null);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Container Apps Environment";
    }

    static {
        ContainerAppsEnvironmentModule.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ContainerAppsEnvironmentModule.java", ContainerAppsEnvironmentModule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "loadResourceFromAzure", "com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironmentModule", "java.lang.String:java.lang.String", "name:resourceGroup", "", "com.azure.resourcemanager.appcontainers.models.ManagedEnvironment"), 40);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "deleteResourceFromAzure", "com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironmentModule", "java.lang.String", "resourceId", "", "void"), 46);
    }
}

