/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerapps.environment;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.implementation.ImplUtils;
import com.azure.core.util.BinaryData;
import com.azure.core.util.ExpandableStringEnum;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.models.BuildConfiguration;
import com.azure.resourcemanager.appcontainers.models.BuildProvisioningState;
import com.azure.resourcemanager.appcontainers.models.BuildResource;
import com.azure.resourcemanager.appcontainers.models.BuildStatus;
import com.azure.resourcemanager.appcontainers.models.BuilderProvisioningState;
import com.azure.resourcemanager.appcontainers.models.BuilderResource;
import com.azure.resourcemanager.appcontainers.models.CheckNameAvailabilityRequest;
import com.azure.resourcemanager.appcontainers.models.CheckNameAvailabilityResponse;
import com.azure.resourcemanager.appcontainers.models.EnvironmentVariable;
import com.azure.resourcemanager.appcontainers.models.ManagedEnvironment;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.action.AzureActionManager;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.exception.StreamingDiagnosticsException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Availability;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.utils.StreamingLogSupport;
import com.microsoft.azure.toolkit.lib.common.utils.UrlStreamingLog;
import com.microsoft.azure.toolkit.lib.containerapps.AzureContainerApps;
import com.microsoft.azure.toolkit.lib.containerapps.AzureContainerAppsServiceSubscription;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.ContainerApp;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironmentModule;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ContainerAppsEnvironment
extends AbstractAzResource<ContainerAppsEnvironment, AzureContainerAppsServiceSubscription, ManagedEnvironment>
implements Deletable,
StreamingLogSupport {
    private static final ObjectMapper mapper;
    public static final Action.Id<ContainerAppsEnvironment> CREATE_CONTAINER_APP;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    protected ContainerAppsEnvironment(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull ContainerAppsEnvironmentModule module) {
        super(name, resourceGroupName, (AbstractAzResourceModule)module);
    }

    public void refresh() {
        ((AzureContainerApps)Azure.az(AzureContainerApps.class)).containerApps(this.getSubscriptionId()).refresh();
        super.refresh();
    }

    protected ContainerAppsEnvironment(@Nonnull ContainerAppsEnvironment insight) {
        super((AbstractAzResource)insight);
    }

    protected ContainerAppsEnvironment(@Nonnull ManagedEnvironment remote, @Nonnull ContainerAppsEnvironmentModule module) {
        super(remote.name(), ResourceId.fromString((String)remote.id()).resourceGroupName(), (AbstractAzResourceModule)module);
    }

    public List<ContainerApp> listContainerApps() {
        return ((AzureContainerApps)Azure.az(AzureContainerApps.class)).containerApps(this.getSubscriptionId()).listContainerAppsByEnvironment(this);
    }

    @Nullable
    public Region getRegion() {
        return Optional.ofNullable(this.getRemote()).map(remote -> Region.fromName((String)remote.region().name())).orElse(null);
    }

    @AzureOperation(name="azure/containerapps.check_name.name", params={"name"})
    public Availability checkContainerAppNameAvailability(String name) {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            CheckNameAvailabilityRequest request = new CheckNameAvailabilityRequest().withName(name).withType("Microsoft.App/containerApps");
            CheckNameAvailabilityResponse result = ((ContainerAppsApiManager)Objects.requireNonNull(((AzureContainerAppsServiceSubscription)this.getModule().getParent()).getRemote())).namespaces().checkNameAvailability(this.getResourceGroupName(), this.getName(), request);
            Availability availability = new Availability(result.nameAvailable().booleanValue(), (String)Optional.ofNullable(result.reason()).map(ExpandableStringEnum::toString).orElse(null), result.message());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return availability;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.emptyList();
    }

    @Nonnull
    protected String loadStatus(@Nonnull ManagedEnvironment remote) {
        return remote.provisioningState().toString();
    }

    public String getLogStreamEndpoint() {
        ManagedEnvironment remoteEnv = (ManagedEnvironment)this.getRemote();
        if (Objects.isNull(remoteEnv)) {
            throw new AzureToolkitRuntimeException(AzureString.format((String)"resource ({0}) not found", (Object[])new Object[]{this.getName()}).toString());
        }
        String baseUrl = String.format("https://%s.azurecontainerapps.dev", Region.fromName((String)remoteEnv.location()).getName());
        return String.format("%s/subscriptions/%s/resourceGroups/%s/managedEnvironments/%s/eventstream", baseUrl, this.getSubscriptionId(), this.getResourceGroupName(), this.getName());
    }

    public String getLogStreamAuthorization() {
        ContainerAppsApiManager manager = (ContainerAppsApiManager)((AzureContainerAppsServiceSubscription)this.getParent()).getRemote();
        String authToken = Optional.ofNullable(manager).map(m -> m.managedEnvironments().getAuthToken(this.getResourceGroupName(), this.getName()).token()).orElse(null);
        return "Bearer " + authToken;
    }

    public BuildResource buildImage(Path sourceTar, Map<String, String> sourceBuildEnv) {
        UUID uuid = UUID.randomUUID();
        String buildId = String.format("build%s", uuid).substring(0, 12);
        String newBuilderName = String.format("builder%s", uuid).substring(0, 12);
        AzureMessager.getMessager().progress(AzureString.format((String)"Starting the Cloud Build for build of id '%s'", (Object[])new Object[]{buildId}));
        BuilderResource builder = this.getOrCreateBuilder(newBuilderName);
        AzureMessager.getMessager().progress(AzureString.format((String)"Creating build '%s' with builder '%s'", (Object[])new Object[]{buildId, builder.name()}));
        List variables = Optional.ofNullable(sourceBuildEnv).orElse(Collections.emptyMap()).entrySet().stream().map(e -> new EnvironmentVariable().withName((String)e.getKey()).withValue((String)e.getValue())).collect(Collectors.toList());
        ContainerAppsApiManager manager = (ContainerAppsApiManager)Objects.requireNonNull(((AzureContainerAppsServiceSubscription)this.getParent()).getRemote());
        BuildResource build = manager.builds().define(buildId).withExistingBuilder(this.getResourceGroupName(), builder.name()).withConfiguration(new BuildConfiguration().withEnvironmentVariables(variables)).create();
        String token = this.getImageBuildAuthToken(build);
        String uploadEndpoint = build.uploadEndpoint() + "?api-version=" + manager.serviceClient().getApiVersion();
        this.uploadFile(sourceTar, uploadEndpoint, token);
        AzureMessager.getMessager().info("Artifact/compressed source code is uploaded successfully.");
        return build;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getImageBuildAuthToken(BuildResource build) {
        ContainerAppsApiManager manager = (ContainerAppsApiManager)Objects.requireNonNull(((AzureContainerAppsServiceSubscription)this.getParent()).getRemote());
        String tokenEndpoint = build.tokenEndpoint() + "?api-version=" + manager.serviceClient().getApiVersion();
        ImmutableMap body = ImmutableMap.of((Object)"location", (Object)Optional.ofNullable(this.getRegion()).map(Region::getName).orElse(com.azure.core.management.Region.US_EAST.name()), (Object)"properties", Collections.emptyMap());
        AzureMessager.getMessager().progress(AzureString.format((String)"Loading token for uploading artifact/compressed source code.", (Object[])new Object[0]));
        HttpRequest tokenRequest = new HttpRequest(HttpMethod.POST, ImplUtils.createUrl((String)tokenEndpoint), new HttpHeaders(), BinaryData.fromObject((Object)body));
        HttpPipeline pipeline = manager.serviceClient().getHttpPipeline();
        try (HttpResponse tokenResponse = (HttpResponse)pipeline.send(tokenRequest).block();){
            if (!Objects.nonNull(tokenResponse)) throw new AzureToolkitRuntimeException("Failed to get token for image build.");
            if (tokenResponse.getStatusCode() != 200) throw new AzureToolkitRuntimeException("Failed to get token for image build.");
            String responseBodyString = (String)tokenResponse.getBodyAsString().block();
            String string = mapper.readTree(responseBodyString).get("token").asText();
            return string;
        }
    }

    @Nullable
    public String waitForImageBuilding(BuildResource build) {
        ImmutableSet errorProvisioningStates = ImmutableSet.of((Object)BuildProvisioningState.CANCELED, (Object)BuildProvisioningState.FAILED, (Object)BuildProvisioningState.DELETING);
        ImmutableSet waitingProvisioningStates = ImmutableSet.of((Object)BuildProvisioningState.CREATING, (Object)BuildProvisioningState.UPDATING);
        UrlStreamingLog urlStreamingLog = UrlStreamingLog.builder().authorization("Bearer " + this.getImageBuildAuthToken(build)).endpoint(build.logStreamEndpoint()).name(build.name()).build();
        Action viewLogInToolkit = AzureActionManager.getInstance().getAction(StreamingLogSupport.OPEN_STREAMING_LOG).bind((Object)urlStreamingLog).withLabel("Open streaming logs");
        AzureMessager.getMessager().info(AzureString.format((String)"Waiting for the build %s to be provisioned...", (Object[])new Object[]{build.name()}), new Object[]{viewLogInToolkit});
        BuildProvisioningState provisioningState = build.provisioningState();
        while (waitingProvisioningStates.contains((Object)provisioningState)) {
            ResourceManagerUtils.sleep((Duration)Duration.ofSeconds(3L));
            build.refresh();
            provisioningState = build.provisioningState();
        }
        if (errorProvisioningStates.contains((Object)provisioningState)) {
            throw new AzureToolkitRuntimeException(String.format("The build %s is not provisioned properly, status: %s", build.name(), provisioningState));
        }
        AzureMessager.getMessager().info(AzureString.format((String)"Build %s is provisioned successfully", (Object[])new Object[]{build.name()}));
        ImmutableSet errorBuildingStates = ImmutableSet.of((Object)BuildStatus.FAILED, (Object)BuildStatus.CANCELED);
        ImmutableSet waitingBuildingStates = ImmutableSet.of((Object)BuildStatus.NOT_STARTED, (Object)BuildStatus.IN_PROGRESS);
        AzureMessager.getMessager().progress(AzureString.format((String)"Waiting for the build %s to be completed...", (Object[])new Object[]{build.name()}));
        BuildStatus buildStatus = build.buildStatus();
        while (waitingBuildingStates.contains((Object)buildStatus)) {
            ResourceManagerUtils.sleep((Duration)Duration.ofSeconds(3L));
            build.refresh();
            buildStatus = build.buildStatus();
        }
        if (errorBuildingStates.contains((Object)buildStatus)) {
            String message = String.format("The build %s is provisioned properly but its build status is %s", build.name(), buildStatus);
            throw new StreamingDiagnosticsException(message, (StreamingLogSupport)urlStreamingLog);
        }
        String image = build.destinationContainerRegistry().image();
        AzureMessager.getMessager().info(AzureString.format((String)"Build %s is completed successfully, image %s is built.", (Object[])new Object[]{build.name(), image}));
        return image;
    }

    public BuilderResource getOrCreateBuilder(String builderName) {
        ContainerAppsApiManager manager = (ContainerAppsApiManager)Objects.requireNonNull(((AzureContainerAppsServiceSubscription)this.getParent()).getRemote());
        String environmentName = this.getName();
        List builders = manager.builders().listByResourceGroup(this.getResourceGroupName()).stream().filter(b -> b.environmentId().endsWith(String.format("/%s", environmentName))).collect(Collectors.toList());
        if (!builders.isEmpty()) {
            BuilderResource builder = (BuilderResource)builders.get(0);
            if (builder.provisioningState() != BuilderProvisioningState.SUCCEEDED) {
                throw new AzureToolkitRuntimeException(String.format("Selected builder %s is not ready to build (current status: %s).", builder.name(), builder.provisioningState()));
            }
            AzureMessager.getMessager().info(AzureString.format((String)"Use existing builder %s in environment %s", (Object[])new Object[]{builderName, this.getName()}));
            return builder;
        }
        AzureMessager.getMessager().progress(AzureString.format((String)"Creating new builder %s in environment %s", (Object[])new Object[]{builderName, this.getName()}));
        return manager.builders().define(builderName).withRegion(Optional.ofNullable(this.getRegion()).map(Region::getName).orElse(com.azure.core.management.Region.US_EAST.name())).withExistingResourceGroup(this.getResourceGroupName()).withEnvironmentId(this.getId()).create();
    }

    public void uploadFile(Path tarFile, String uploadEndpoint, String token) {
        File dataFile = tarFile.toFile();
        String fileName = dataFile.getName();
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost request = new HttpPost(uploadEndpoint);
            request.addHeader("Authorization", "Bearer " + token);
            FileBody fileBody = new FileBody(tarFile.toFile());
            HttpEntity multipartEntity = MultipartEntityBuilder.create().addPart("file", (ContentBody)fileBody).build();
            request.setEntity(multipartEntity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            int code = response.getStatusLine().getStatusCode();
            if (code != 200) {
                HttpEntity responseEntity = response.getEntity();
                if (responseEntity != null) {
                    String responseString = EntityUtils.toString((HttpEntity)responseEntity);
                    throw new AzureToolkitRuntimeException(String.format("Error when uploading artifact/source code, request exited with %s: %s", code, responseString));
                }
                throw new AzureToolkitRuntimeException(String.format("Error when uploading artifact/source code, request exited with %s", code));
            }
        }
        catch (Exception e) {
            throw new AzureToolkitRuntimeException("Error when uploading artifact/source code", (Throwable)e);
        }
    }

    static {
        ContainerAppsEnvironment.ajc$preClinit();
        mapper = new ObjectMapper();
        CREATE_CONTAINER_APP = Action.Id.of((String)"user/containerapps.create_container_app");
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ContainerAppsEnvironment.java", ContainerAppsEnvironment.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "checkContainerAppNameAvailability", "com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironment", "java.lang.String", "name", "", "com.microsoft.azure.toolkit.lib.common.model.Availability"), 109);
    }
}

