/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerapps.containerapp;

import com.azure.resourcemanager.appcontainers.implementation.ContainerAppImpl;
import com.azure.resourcemanager.appcontainers.models.ActiveRevisionsMode;
import com.azure.resourcemanager.appcontainers.models.BuildResource;
import com.azure.resourcemanager.appcontainers.models.Configuration;
import com.azure.resourcemanager.appcontainers.models.Container;
import com.azure.resourcemanager.appcontainers.models.ContainerApp;
import com.azure.resourcemanager.appcontainers.models.ContainerApps;
import com.azure.resourcemanager.appcontainers.models.EnvironmentVar;
import com.azure.resourcemanager.appcontainers.models.Ingress;
import com.azure.resourcemanager.appcontainers.models.RegistryCredentials;
import com.azure.resourcemanager.appcontainers.models.Scale;
import com.azure.resourcemanager.appcontainers.models.Secret;
import com.azure.resourcemanager.appcontainers.models.Template;
import com.azure.resourcemanager.containerregistry.models.RegistryTaskRun;
import com.google.common.collect.Sets;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.action.AzureActionManager;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import com.microsoft.azure.toolkit.lib.common.task.AzureTaskManager;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.ContainerApp;
import com.microsoft.azure.toolkit.lib.containerapps.containerapp.ContainerAppModule;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironment;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironmentDraft;
import com.microsoft.azure.toolkit.lib.containerapps.model.IngressConfig;
import com.microsoft.azure.toolkit.lib.containerapps.model.RevisionMode;
import com.microsoft.azure.toolkit.lib.containerregistry.AzureContainerRegistry;
import com.microsoft.azure.toolkit.lib.containerregistry.AzureContainerRegistryModule;
import com.microsoft.azure.toolkit.lib.containerregistry.ContainerRegistry;
import com.microsoft.azure.toolkit.lib.containerregistry.ContainerRegistryDraft;
import com.microsoft.azure.toolkit.lib.containerregistry.model.Sku;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ContainerAppDraft
extends ContainerApp
implements AzResource.Draft<ContainerApp, com.azure.resourcemanager.appcontainers.models.ContainerApp> {
    @Nullable
    private final ContainerApp origin;
    private Config config;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    protected ContainerAppDraft(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull ContainerAppModule module) {
        super(name, resourceGroupName, module);
        this.origin = null;
    }

    protected ContainerAppDraft(@Nonnull ContainerApp origin) {
        super(origin);
        this.origin = origin;
    }

    public void reset() {
        this.config = null;
    }

    @Nonnull
    @AzureOperation(name="azure/containerapps.create_app.app", params={"this.getName()"})
    public com.azure.resourcemanager.appcontainers.models.ContainerApp createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ContainerApps client = Objects.requireNonNull(((ContainerAppModule)this.getModule()).getClient());
            ContainerAppsEnvironment containerAppsEnvironment = Objects.requireNonNull(this.ensureConfig().getEnvironment(), "Environment is required to create Container app.");
            if (containerAppsEnvironment.isDraftForCreating()) {
                ((ContainerAppsEnvironmentDraft)containerAppsEnvironment).commit();
            }
            ImageConfig imageConfig = Objects.requireNonNull(this.getImageConfig(), "Image is required to create Container app.");
            this.buildImageIfNeeded(imageConfig);
            Configuration configuration = new Configuration();
            Optional.ofNullable(this.ensureConfig().getRevisionMode()).ifPresent(mode -> configuration.withActiveRevisionsMode(ActiveRevisionsMode.fromString((String)this.ensureConfig().getRevisionMode().getValue())));
            configuration.withSecrets(Optional.ofNullable(ContainerAppDraft.getSecret(imageConfig)).map(Collections::singletonList).orElse(Collections.emptyList()));
            configuration.withRegistries(Optional.ofNullable(ContainerAppDraft.getRegistryCredential(imageConfig)).map(Collections::singletonList).orElse(Collections.emptyList()));
            configuration.withIngress((Ingress)Optional.ofNullable(this.ensureConfig().getIngressConfig()).map(IngressConfig::toIngress).orElse(null));
            Template template = new Template().withContainers(ImageConfig.toContainers(imageConfig)).withScale(ScaleConfig.toScale(this.getScaleConfig()));
            AzureMessager.getMessager().progress(AzureString.format((String)"Creating Azure Container App({0})...", (Object[])new Object[]{this.getName()}));
            com.azure.resourcemanager.appcontainers.models.ContainerApp result = client.define(this.ensureConfig().getName()).withRegion(com.azure.core.management.Region.fromName((String)containerAppsEnvironment.getRegion().getName())).withExistingResourceGroup(Objects.requireNonNull(this.ensureConfig().getResourceGroup(), "Resource Group is required to create Container app.").getResourceGroupName()).withManagedEnvironmentId(containerAppsEnvironment.getId()).withConfiguration(configuration).withTemplate(template).create();
            Action updateImage = AzureActionManager.getInstance().getAction(ContainerApp.UPDATE_IMAGE).bind((Object)this);
            Action browse = AzureActionManager.getInstance().getAction(ContainerApp.BROWSE).bind((Object)this);
            AzureMessager.getMessager().success(AzureString.format((String)"Azure Container App({0}) is successfully created.", (Object[])new Object[]{this.getName()}), new Object[]{browse, updateImage});
            com.azure.resourcemanager.appcontainers.models.ContainerApp containerApp = result;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return containerApp;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @AzureOperation(name="azure/containerapps.update_app.app", params={"this.getName()"})
    public com.azure.resourcemanager.appcontainers.models.ContainerApp updateResourceInAzure(@Nonnull com.azure.resourcemanager.appcontainers.models.ContainerApp origin) {
        com.azure.resourcemanager.appcontainers.models.ContainerApp containerApp = origin;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)containerApp);
        try {
            com.azure.resourcemanager.appcontainers.models.ContainerApp containerApp2;
            boolean isModified;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            IAzureMessager messager = AzureMessager.getMessager();
            Config config = this.ensureConfig();
            ImageConfig imageConfig = config.getImageConfig();
            IngressConfig ingressConfig = config.getIngressConfig();
            RevisionMode revisionMode = config.getRevisionMode();
            ScaleConfig scaleConfig = config.getScaleConfig();
            boolean isImageModified = Objects.nonNull(imageConfig) && !Objects.equals(imageConfig, super.getImageConfig());
            boolean isIngressConfigModified = Objects.nonNull(ingressConfig) && !Objects.equals(ingressConfig, super.getIngressConfig());
            boolean isRevisionModeModified = !Objects.equals(revisionMode, super.getRevisionMode());
            boolean isScaleModified = !Objects.equals(scaleConfig, super.getScaleConfig());
            boolean bl = isModified = isImageModified || isIngressConfigModified || isRevisionModeModified || isScaleModified;
            if (!isModified) {
                containerApp2 = origin;
            } else {
                this.buildImageIfNeeded(imageConfig);
                ContainerAppImpl update = (ContainerAppImpl)(isImageModified ? this.updateImage(origin) : origin.update());
                Configuration configuration = update.configuration();
                if (!isImageModified) {
                    List secrets = origin.listSecrets().value().stream().map(s -> new Secret().withName(s.name()).withValue(s.value())).collect(Collectors.toList());
                    List registries = Optional.ofNullable(origin.configuration().registries()).map(ArrayList::new).orElseGet(ArrayList::new);
                    configuration.withRegistries(registries).withSecrets(secrets);
                }
                if (isIngressConfigModified) {
                    configuration.withIngress(ingressConfig.toIngress());
                }
                if (isRevisionModeModified) {
                    configuration.withActiveRevisionsMode(revisionMode.toActiveRevisionMode());
                }
                if (isScaleModified) {
                    if (isImageModified) {
                        update.withTemplate(update.template().withScale(ScaleConfig.toScale(scaleConfig)));
                    } else {
                        update.withTemplate(new Template().withScale(ScaleConfig.toScale(scaleConfig)));
                    }
                }
                update.withConfiguration(configuration);
                messager.progress(AzureString.format((String)"Updating Container App({0})...", (Object[])new Object[]{this.getName()}));
                com.azure.resourcemanager.appcontainers.models.ContainerApp result = update.apply();
                Action browse = AzureActionManager.getInstance().getAction(ContainerApp.BROWSE).bind((Object)this);
                messager.success(AzureString.format((String)"Container App({0}) is successfully updated.", (Object[])new Object[]{this.getName()}), new Object[]{browse});
                if (isImageModified) {
                    AzureTaskManager.getInstance().runOnPooledThread(() -> this.getRevisionModule().refresh());
                }
                containerApp2 = result;
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return containerApp2;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    private ContainerApp.Update updateImage(@Nonnull com.azure.resourcemanager.appcontainers.models.ContainerApp origin) {
        ImageConfig config = Objects.requireNonNull(this.getConfig().getImageConfig(), "image config is null.");
        ContainerApp.Update update = origin.update();
        ContainerRegistry registry = config.getContainerRegistry();
        List secrets = origin.listSecrets().value().stream().map(s -> new Secret().withName(s.name()).withValue(s.value())).collect(Collectors.toList());
        List registries = Optional.ofNullable(origin.configuration().registries()).map(ArrayList::new).orElseGet(ArrayList::new);
        if (Objects.nonNull(registry)) {
            Optional.ofNullable(ContainerAppDraft.getSecret(config)).ifPresent(secret -> {
                secrets.removeIf(r -> r.name().equalsIgnoreCase(secret.name()));
                secrets.add(secret);
            });
            Optional.ofNullable(ContainerAppDraft.getRegistryCredential(config)).ifPresent(credential -> {
                registries.removeIf(r -> r.server().equalsIgnoreCase(credential.server()));
                registries.add(credential);
            });
        }
        update.withConfiguration(origin.configuration().withRegistries(registries).withSecrets(secrets));
        return update.withTemplate(origin.template().withContainers(ImageConfig.toContainers(config)));
    }

    public void buildImageIfNeeded(ImageConfig imageConfig) {
        String fullImageName;
        if (!Optional.ofNullable(imageConfig).map(ImageConfig::getBuildImageConfig).map(b -> ((BuildImageConfig)b).source).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).isPresent()) {
            OperationContext.action().setTelemetryProperty("needBuildImage", "false");
            return;
        }
        OperationContext.action().setTelemetryProperty("needBuildImage", "true");
        OperationContext.action().setTelemetryProperty("hasDockerFile", String.valueOf(imageConfig.sourceHasDockerFile()));
        BuildImageConfig buildConfig = Objects.requireNonNull(imageConfig.getBuildImageConfig());
        if (imageConfig.sourceHasDockerFile()) {
            AzureMessager.getMessager().warning("Dockerfile detected. Running the build through ACR.");
            ContainerRegistry registry = this.getOrCreateRegistry(imageConfig);
            ContainerAppDraft.tarSourceIfNeeded(buildConfig);
            RegistryTaskRun run = registry.buildImage(imageConfig.getAcrImageNameWithTag(), buildConfig.getSource());
            if (Objects.isNull(run)) {
                throw new AzureToolkitRuntimeException("ACR is not ready, Failed to build image through ACR.");
            }
            fullImageName = registry.waitForImageBuilding(run);
        } else {
            OperationContext.action().setTelemetryProperty("isDirectory", String.valueOf(Files.isDirectory(buildConfig.source, new LinkOption[0])));
            if (Files.isDirectory(buildConfig.source, new LinkOption[0])) {
                AzureMessager.getMessager().warning("No Dockerfile detected. Building container image from source code through Container Apps cloud build.");
            } else {
                AzureMessager.getMessager().warning("Building container image from artifact through Container Apps cloud build.");
            }
            ContainerAppsEnvironment environment = Objects.requireNonNull(this.getManagedEnvironment());
            ContainerAppDraft.tarSourceIfNeeded(buildConfig);
            BuildResource build = environment.buildImage(buildConfig.getSource(), buildConfig.sourceBuildEnv);
            fullImageName = environment.waitForImageBuilding(build);
        }
        if (StringUtils.isNotBlank((CharSequence)fullImageName)) {
            imageConfig.setFullImageName(fullImageName);
        }
    }

    private static void tarSourceIfNeeded(BuildImageConfig buildConfig) {
        if (Files.isDirectory(buildConfig.source, new LinkOption[0])) {
            HashSet ignored = Sets.newHashSet((Object[])new String[]{".git", ".gitignore", ".bzr", "bzrignore", ".hg", ".hgignore", ".svn"});
            AzureMessager.getMessager().progress(AzureString.format((String)"Creating tar.gz from %s.", (Object[])new Object[]{buildConfig.source.getFileName()}));
            Path sourceTar = Utils.tar((Path)buildConfig.source, path -> ignored.contains(path.getFileName().toString()));
            buildConfig.setSource(sourceTar);
        }
    }

    @Nonnull
    private ContainerRegistry getOrCreateRegistry(ImageConfig config) {
        ContainerRegistry registry = config.getContainerRegistry();
        if (Objects.isNull(registry)) {
            String registryName = Objects.requireNonNull(config.getAcrRegistryName());
            AzureContainerRegistryModule registryModule = ((AzureContainerRegistry)Azure.az(AzureContainerRegistry.class)).registry(this.getSubscriptionId());
            registry = (ContainerRegistry)registryModule.get(registryName, this.getResourceGroupName());
            if (Objects.isNull(registry)) {
                List registries = registryModule.listByResourceGroup(this.getResourceGroupName());
                if (!registries.isEmpty() && Objects.isNull(registry = (ContainerRegistry)registries.stream().filter(ContainerRegistry::isAdminUserEnabled).findAny().orElse(null))) {
                    registry = registries.stream().findFirst().orElse(null);
                }
                if (Objects.isNull(registry)) {
                    AzureMessager.getMessager().info(AzureString.format((String)"creating new container registry %s with admin user enabled.", (Object[])new Object[]{registryName}));
                    registry = (ContainerRegistry)registryModule.create(registryName, this.getResourceGroupName());
                    ContainerRegistryDraft draft = (ContainerRegistryDraft)registry;
                    draft.setSku(Sku.Standard);
                    draft.setAdminUserEnabled(Boolean.valueOf(true));
                    draft.setRegion(Optional.ofNullable(this.getRegion()).orElse(Region.US_EAST));
                    draft.commit();
                } else {
                    AzureMessager.getMessager().info(AzureString.format((String)"use container registry %s.", (Object[])new Object[]{registry.getName()}));
                }
            }
        }
        if (registry.isDraftForCreating()) {
            ((ContainerRegistryDraft)registry).setAdminUserEnabled(Boolean.valueOf(true));
            ((ContainerRegistryDraft)registry).commit();
        } else if (!registry.isAdminUserEnabled()) {
            AzureMessager.getMessager().info(AzureString.format((String)"Enabling admin user for container registry %s.", (Object[])new Object[]{registry.getName()}));
            registry.enableAdminUser();
        }
        config.setContainerRegistry(registry);
        return registry;
    }

    @Nullable
    private static Secret getSecret(ImageConfig config) {
        ContainerRegistry registry = config.getContainerRegistry();
        if (Objects.nonNull(registry)) {
            String password = Optional.ofNullable(registry.getPrimaryCredential()).orElseGet(() -> ((ContainerRegistry)registry).getSecondaryCredential());
            String passwordKey = Objects.equals(password, registry.getPrimaryCredential()) ? "password" : "password2";
            String passwordName = String.format("%s-%s", registry.getName().toLowerCase(), passwordKey);
            return new Secret().withName(passwordName).withValue(password);
        }
        return null;
    }

    @Nullable
    private static RegistryCredentials getRegistryCredential(ImageConfig config) {
        ContainerRegistry registry = config.getContainerRegistry();
        if (Objects.nonNull(registry)) {
            String username = registry.getUserName();
            String password = Optional.ofNullable(registry.getPrimaryCredential()).orElseGet(() -> ((ContainerRegistry)registry).getSecondaryCredential());
            String passwordKey = Objects.equals(password, registry.getPrimaryCredential()) ? "password" : "password2";
            String passwordName = String.format("%s-%s", registry.getName().toLowerCase(), passwordKey);
            return new RegistryCredentials().withServer(registry.getLoginServerUrl()).withUsername(username).withPasswordSecretRef(passwordName);
        }
        return null;
    }

    @Nonnull
    private synchronized Config ensureConfig() {
        this.config = Optional.ofNullable(this.config).orElseGet(Config::new);
        return this.config;
    }

    @Override
    @Nullable
    public ScaleConfig getScaleConfig() {
        return Optional.ofNullable(this.config).map(Config::getScaleConfig).orElse(super.getScaleConfig());
    }

    @Override
    @Nullable
    public IngressConfig getIngressConfig() {
        return Optional.ofNullable(this.config).map(Config::getIngressConfig).orElse(super.getIngressConfig());
    }

    @Override
    @Nullable
    public ImageConfig getImageConfig() {
        return Optional.ofNullable(this.config).map(Config::getImageConfig).orElse(super.getImageConfig());
    }

    @Override
    @Nullable
    public RevisionMode getRevisionMode() {
        return Optional.ofNullable(this.config).map(Config::getRevisionMode).orElse(super.getRevisionMode());
    }

    @Override
    @Nullable
    public ContainerAppsEnvironment getManagedEnvironment() {
        return Optional.ofNullable(this.config).map(Config::getEnvironment).orElseGet(() -> super.getManagedEnvironment());
    }

    @Override
    @Nullable
    public String getManagedEnvironmentId() {
        return Optional.ofNullable(this.config).map(Config::getEnvironment).map(AbstractAzResource::getId).orElseGet(() -> super.getManagedEnvironmentId());
    }

    @Override
    @Nullable
    public Region getRegion() {
        return Optional.ofNullable(this.config).map(Config::getEnvironment).map(ContainerAppsEnvironment::getRegion).orElseGet(() -> super.getRegion());
    }

    @Override
    public boolean isIngressEnabled() {
        return Optional.ofNullable(this.config).map(Config::getIngressConfig).map(IngressConfig::isEnableIngress).orElseGet(() -> super.isIngressEnabled());
    }

    public boolean isModified() {
        return this.config == null || Objects.equals(this.config, new Config());
    }

    @Nullable
    public ContainerApp getOrigin() {
        return this.origin;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    static {
        ContainerAppDraft.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ContainerAppDraft.java", ContainerAppDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.containerapps.containerapp.ContainerAppDraft", "", "", "", "com.azure.resourcemanager.appcontainers.models.ContainerApp"), 98);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.containerapps.containerapp.ContainerAppDraft", "com.azure.resourcemanager.appcontainers.models.ContainerApp", "origin", "", "com.azure.resourcemanager.appcontainers.models.ContainerApp"), 134);
    }

    public static class ScaleConfig {
        private Integer maxReplicas;
        private Integer minReplicas;

        public static Scale toScale(ScaleConfig config) {
            return Optional.ofNullable(config).map(s -> new Scale().withMinReplicas(s.minReplicas).withMaxReplicas(s.maxReplicas)).orElse(null);
        }

        private static Integer $default$minReplicas() {
            return 1;
        }

        ScaleConfig(Integer maxReplicas, Integer minReplicas) {
            this.maxReplicas = maxReplicas;
            this.minReplicas = minReplicas;
        }

        public static ScaleConfigBuilder builder() {
            return new ScaleConfigBuilder();
        }

        public Integer getMaxReplicas() {
            return this.maxReplicas;
        }

        public Integer getMinReplicas() {
            return this.minReplicas;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScaleConfig)) {
                return false;
            }
            ScaleConfig other = (ScaleConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$maxReplicas = this.getMaxReplicas();
            Integer other$maxReplicas = other.getMaxReplicas();
            if (this$maxReplicas == null ? other$maxReplicas != null : !((Object)this$maxReplicas).equals(other$maxReplicas)) {
                return false;
            }
            Integer this$minReplicas = this.getMinReplicas();
            Integer other$minReplicas = other.getMinReplicas();
            return !(this$minReplicas == null ? other$minReplicas != null : !((Object)this$minReplicas).equals(other$minReplicas));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ScaleConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $maxReplicas = this.getMaxReplicas();
            result = result * 59 + ($maxReplicas == null ? 43 : ((Object)$maxReplicas).hashCode());
            Integer $minReplicas = this.getMinReplicas();
            result = result * 59 + ($minReplicas == null ? 43 : ((Object)$minReplicas).hashCode());
            return result;
        }

        public static class ScaleConfigBuilder {
            private Integer maxReplicas;
            private boolean minReplicas$set;
            private Integer minReplicas$value;

            ScaleConfigBuilder() {
            }

            public ScaleConfigBuilder maxReplicas(Integer maxReplicas) {
                this.maxReplicas = maxReplicas;
                return this;
            }

            public ScaleConfigBuilder minReplicas(Integer minReplicas) {
                this.minReplicas$value = minReplicas;
                this.minReplicas$set = true;
                return this;
            }

            public ScaleConfig build() {
                Integer minReplicas$value = this.minReplicas$value;
                if (!this.minReplicas$set) {
                    minReplicas$value = ScaleConfig.$default$minReplicas();
                }
                return new ScaleConfig(this.maxReplicas, minReplicas$value);
            }

            public String toString() {
                return "ContainerAppDraft.ScaleConfig.ScaleConfigBuilder(maxReplicas=" + this.maxReplicas + ", minReplicas$value=" + this.minReplicas$value + ")";
            }
        }
    }

    public static class BuildImageConfig {
        @Nonnull
        private Path source;
        private Map<String, String> sourceBuildEnv;

        public boolean sourceHasDockerFile() {
            return Optional.of(this.source).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(p -> Files.isRegularFile(Paths.get(p.toString(), "Dockerfile"), new LinkOption[0])).orElse(false);
        }

        @Nonnull
        public Path getSource() {
            return this.source;
        }

        public Map<String, String> getSourceBuildEnv() {
            return this.sourceBuildEnv;
        }

        public void setSource(@Nonnull Path source) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            this.source = source;
        }

        public void setSourceBuildEnv(Map<String, String> sourceBuildEnv) {
            this.sourceBuildEnv = sourceBuildEnv;
        }
    }

    public static class ImageConfig {
        @Nonnull
        private String fullImageName;
        @Nullable
        private ContainerRegistry containerRegistry;
        @Nonnull
        private List<EnvironmentVar> environmentVariables = new ArrayList<EnvironmentVar>();
        @Nullable
        private BuildImageConfig buildImageConfig;

        public ImageConfig(@Nonnull String fullImageName) {
            this.fullImageName = fullImageName;
        }

        public String getTag() {
            return Optional.of(this.fullImageName.substring(this.fullImageName.lastIndexOf(58) + 1)).filter(StringUtils::isNotBlank).orElse("latest");
        }

        public String getRegistryUrl() {
            return this.fullImageName.substring(0, this.fullImageName.indexOf(47));
        }

        @Nullable
        public String getAcrRegistryName() {
            String registryUrl = this.getRegistryUrl();
            if (registryUrl.endsWith(".azurecr.io")) {
                return registryUrl.substring(0, registryUrl.length() - ".azurecr.io".length());
            }
            return null;
        }

        public String getAcrImageNameWithTag() {
            return this.fullImageName.substring(this.fullImageName.indexOf(47) + 1);
        }

        public boolean sourceHasDockerFile() {
            return Optional.ofNullable(this.buildImageConfig).map(BuildImageConfig::sourceHasDockerFile).orElse(false);
        }

        public static List<Container> toContainers(@Nonnull ImageConfig config) {
            String imageId = config.getFullImageName();
            String containerName = ImageConfig.getContainerNameForImage(imageId);
            return Collections.singletonList(new Container().withName(containerName).withImage(imageId).withEnv(config.getEnvironmentVariables()));
        }

        private static String getContainerNameForImage(String containerImageName) {
            String name = containerImageName.substring(containerImageName.lastIndexOf(47) + 1).replaceAll("[^0-9a-zA-Z-]", "-").toLowerCase();
            return StringUtils.substring((String)name, (int)0, (int)46);
        }

        public void setFullImageName(@Nonnull String fullImageName) {
            if (fullImageName == null) {
                throw new NullPointerException("fullImageName is marked non-null but is null");
            }
            this.fullImageName = fullImageName;
        }

        public void setContainerRegistry(@Nullable ContainerRegistry containerRegistry) {
            this.containerRegistry = containerRegistry;
        }

        public void setEnvironmentVariables(@Nonnull List<EnvironmentVar> environmentVariables) {
            if (environmentVariables == null) {
                throw new NullPointerException("environmentVariables is marked non-null but is null");
            }
            this.environmentVariables = environmentVariables;
        }

        public void setBuildImageConfig(@Nullable BuildImageConfig buildImageConfig) {
            this.buildImageConfig = buildImageConfig;
        }

        @Nonnull
        public String getFullImageName() {
            return this.fullImageName;
        }

        @Nullable
        public ContainerRegistry getContainerRegistry() {
            return this.containerRegistry;
        }

        @Nonnull
        public List<EnvironmentVar> getEnvironmentVariables() {
            return this.environmentVariables;
        }

        @Nullable
        public BuildImageConfig getBuildImageConfig() {
            return this.buildImageConfig;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImageConfig)) {
                return false;
            }
            ImageConfig other = (ImageConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fullImageName = this.getFullImageName();
            String other$fullImageName = other.getFullImageName();
            return !(this$fullImageName == null ? other$fullImageName != null : !this$fullImageName.equals(other$fullImageName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ImageConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fullImageName = this.getFullImageName();
            result = result * 59 + ($fullImageName == null ? 43 : $fullImageName.hashCode());
            return result;
        }
    }

    public static class Config {
        private String name;
        private Subscription subscription;
        private ResourceGroup resourceGroup;
        @Nullable
        private ContainerAppsEnvironment environment;
        private RevisionMode revisionMode = RevisionMode.SINGLE;
        @Nullable
        private ImageConfig imageConfig;
        @Nullable
        private IngressConfig ingressConfig;
        @Nullable
        private ScaleConfig scaleConfig;

        public String getName() {
            return this.name;
        }

        public Subscription getSubscription() {
            return this.subscription;
        }

        public ResourceGroup getResourceGroup() {
            return this.resourceGroup;
        }

        @Nullable
        public ContainerAppsEnvironment getEnvironment() {
            return this.environment;
        }

        public RevisionMode getRevisionMode() {
            return this.revisionMode;
        }

        @Nullable
        public ImageConfig getImageConfig() {
            return this.imageConfig;
        }

        @Nullable
        public IngressConfig getIngressConfig() {
            return this.ingressConfig;
        }

        @Nullable
        public ScaleConfig getScaleConfig() {
            return this.scaleConfig;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setSubscription(Subscription subscription) {
            this.subscription = subscription;
        }

        public void setResourceGroup(ResourceGroup resourceGroup) {
            this.resourceGroup = resourceGroup;
        }

        public void setEnvironment(@Nullable ContainerAppsEnvironment environment) {
            this.environment = environment;
        }

        public void setRevisionMode(RevisionMode revisionMode) {
            this.revisionMode = revisionMode;
        }

        public void setImageConfig(@Nullable ImageConfig imageConfig) {
            this.imageConfig = imageConfig;
        }

        public void setIngressConfig(@Nullable IngressConfig ingressConfig) {
            this.ingressConfig = ingressConfig;
        }

        public void setScaleConfig(@Nullable ScaleConfig scaleConfig) {
            this.scaleConfig = scaleConfig;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Subscription this$subscription = this.getSubscription();
            Subscription other$subscription = other.getSubscription();
            if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) {
                return false;
            }
            ResourceGroup this$resourceGroup = this.getResourceGroup();
            ResourceGroup other$resourceGroup = other.getResourceGroup();
            if (this$resourceGroup == null ? other$resourceGroup != null : !this$resourceGroup.equals(other$resourceGroup)) {
                return false;
            }
            ContainerAppsEnvironment this$environment = this.getEnvironment();
            ContainerAppsEnvironment other$environment = other.getEnvironment();
            if (this$environment == null ? other$environment != null : !((Object)((Object)this$environment)).equals((Object)other$environment)) {
                return false;
            }
            RevisionMode this$revisionMode = this.getRevisionMode();
            RevisionMode other$revisionMode = other.getRevisionMode();
            if (this$revisionMode == null ? other$revisionMode != null : !((Object)this$revisionMode).equals(other$revisionMode)) {
                return false;
            }
            ImageConfig this$imageConfig = this.getImageConfig();
            ImageConfig other$imageConfig = other.getImageConfig();
            if (this$imageConfig == null ? other$imageConfig != null : !((Object)this$imageConfig).equals(other$imageConfig)) {
                return false;
            }
            IngressConfig this$ingressConfig = this.getIngressConfig();
            IngressConfig other$ingressConfig = other.getIngressConfig();
            if (this$ingressConfig == null ? other$ingressConfig != null : !((Object)this$ingressConfig).equals(other$ingressConfig)) {
                return false;
            }
            ScaleConfig this$scaleConfig = this.getScaleConfig();
            ScaleConfig other$scaleConfig = other.getScaleConfig();
            return !(this$scaleConfig == null ? other$scaleConfig != null : !((Object)this$scaleConfig).equals(other$scaleConfig));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Subscription $subscription = this.getSubscription();
            result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
            ResourceGroup $resourceGroup = this.getResourceGroup();
            result = result * 59 + ($resourceGroup == null ? 43 : $resourceGroup.hashCode());
            ContainerAppsEnvironment $environment = this.getEnvironment();
            result = result * 59 + ($environment == null ? 43 : ((Object)((Object)$environment)).hashCode());
            RevisionMode $revisionMode = this.getRevisionMode();
            result = result * 59 + ($revisionMode == null ? 43 : ((Object)$revisionMode).hashCode());
            ImageConfig $imageConfig = this.getImageConfig();
            result = result * 59 + ($imageConfig == null ? 43 : ((Object)$imageConfig).hashCode());
            IngressConfig $ingressConfig = this.getIngressConfig();
            result = result * 59 + ($ingressConfig == null ? 43 : ((Object)$ingressConfig).hashCode());
            ScaleConfig $scaleConfig = this.getScaleConfig();
            result = result * 59 + ($scaleConfig == null ? 43 : ((Object)$scaleConfig).hashCode());
            return result;
        }

        public String toString() {
            return "ContainerAppDraft.Config(name=" + this.getName() + ", subscription=" + this.getSubscription() + ", resourceGroup=" + this.getResourceGroup() + ", environment=" + (Object)((Object)this.getEnvironment()) + ", revisionMode=" + this.getRevisionMode() + ", imageConfig=" + this.getImageConfig() + ", ingressConfig=" + this.getIngressConfig() + ", scaleConfig=" + this.getScaleConfig() + ")";
        }
    }
}

