/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.serviceprincipal;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientCertificateCredentialBuilder;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AuthConfiguration;
import com.microsoft.azure.toolkit.lib.auth.AuthType;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServicePrincipalAccount
extends Account {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServicePrincipalAccount.class);
    private final AuthType type = AuthType.SERVICE_PRINCIPAL;

    public ServicePrincipalAccount(@Nonnull AuthConfiguration config) {
        super(config);
    }

    @Override
    public boolean checkAvailable() {
        AuthConfiguration config = this.getConfig();
        boolean available = !StringUtils.isAllBlank((CharSequence[])new CharSequence[]{config.getCertificate(), config.getCertificatePassword(), config.getKey()});
        log.trace("Auth type ({}) is {}available.", (Object)TextUtils.cyan((String)this.getType().name()), (Object)(available ? "" : TextUtils.yellow((String)"NOT ")));
        return available;
    }

    @Override
    @Nonnull
    protected TokenCredential buildDefaultTokenCredential() {
        AuthConfiguration config = this.getConfig();
        return StringUtils.isNotBlank((CharSequence)config.getCertificate()) ? ((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)new ClientCertificateCredentialBuilder().tenantId(config.getTenant())).clientId(config.getClient())).pfxCertificate(config.getCertificate(), config.getCertificatePassword()).additionallyAllowedTenants(new String[]{"*"})).tokenCachePersistenceOptions(this.getPersistenceOptions()).executorService(config.getExecutorService())).build() : ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().tenantId(config.getTenant())).clientId(config.getClient())).clientSecret(config.getKey()).additionallyAllowedTenants(new String[]{"*"})).tokenCachePersistenceOptions(this.getPersistenceOptions()).executorService(config.getExecutorService())).build();
    }

    @Override
    public String getClientId() {
        return this.getConfig().getClient();
    }

    @Override
    @Generated
    public AuthType getType() {
        return this.type;
    }
}

