/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.managedidentity;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AuthConfiguration;
import com.microsoft.azure.toolkit.lib.auth.AuthType;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedIdentityAccount
extends Account {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ManagedIdentityAccount.class);
    private final AuthType type = AuthType.MANAGED_IDENTITY;

    public ManagedIdentityAccount() {
        super(new AuthConfiguration(AuthType.MANAGED_IDENTITY));
    }

    public ManagedIdentityAccount(@Nonnull AuthConfiguration config) {
        super(config);
    }

    @Override
    @Nonnull
    protected TokenCredential buildDefaultTokenCredential() {
        return new ManagedIdentityCredentialBuilder().clientId(this.getClientId()).build();
    }

    @Override
    public boolean checkAvailable() {
        boolean available = this.getManagementToken().isPresent();
        log.trace("Auth type ({}) is {}available.", (Object)TextUtils.cyan((String)this.getType().name()), (Object)(available ? "" : TextUtils.yellow((String)"NOT ")));
        return available;
    }

    @Override
    @Generated
    public AuthType getType() {
        return this.type;
    }
}

