/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.cli;

import com.azure.core.management.AzureEnvironment;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.azure.toolkit.lib.auth.AzureEnvironmentUtils;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
class AzureCliSubscription
extends Subscription {
    @JsonProperty
    private String homeTenantId;
    @JsonProperty
    private String state;
    @JsonProperty(value="isDefault")
    private boolean selected;
    @JsonIgnore
    private AzureEnvironment environment;
    @JsonIgnore
    private String email;

    AzureCliSubscription() {
    }

    @JsonProperty(value="user")
    public void setUser(Map<String, String> user) {
        this.email = user.get("name");
    }

    @JsonProperty(value="cloudName")
    public void setCloudName(String cloudName) {
        this.environment = AzureEnvironmentUtils.stringToAzureEnvironment(cloudName);
    }

    @JsonProperty
    @Generated
    public void setHomeTenantId(String homeTenantId) {
        this.homeTenantId = homeTenantId;
    }

    @JsonProperty
    @Generated
    public void setState(String state) {
        this.state = state;
    }

    @JsonProperty(value="isDefault")
    @Generated
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @JsonIgnore
    @Generated
    public void setEnvironment(AzureEnvironment environment) {
        this.environment = environment;
    }

    @JsonIgnore
    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public String getHomeTenantId() {
        return this.homeTenantId;
    }

    @Generated
    public String getState() {
        return this.state;
    }

    @Generated
    public boolean isSelected() {
        return this.selected;
    }

    @Generated
    public AzureEnvironment getEnvironment() {
        return this.environment;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }
}

