/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth.cli;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.SimpleTokenCache;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.management.AzureEnvironment;
import com.azure.identity.implementation.util.ScopeUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AuthConfiguration;
import com.microsoft.azure.toolkit.lib.auth.AuthType;
import com.microsoft.azure.toolkit.lib.auth.AzureCloud;
import com.microsoft.azure.toolkit.lib.auth.AzureEnvironmentUtils;
import com.microsoft.azure.toolkit.lib.auth.AzureToolkitAuthenticationException;
import com.microsoft.azure.toolkit.lib.auth.cli.AzureCliSubscription;
import com.microsoft.azure.toolkit.lib.auth.cli.AzureCliUtils;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.common.utils.JsonUtils;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class AzureCliAccount
extends Account {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AzureCliAccount.class);
    private static final String CLOUD_SHELL_ENV_KEY = "ACC_CLOUD";
    private final AuthType type = AuthType.AZURE_CLI;
    private String username;

    public AzureCliAccount(AuthConfiguration config) {
        super(config);
    }

    @Override
    @Nonnull
    protected List<Subscription> loadSubscriptions() {
        List<AzureCliSubscription> cliSubs = AzureCliUtils.listSubscriptions();
        if (cliSubs.isEmpty()) {
            throw new AzureToolkitAuthenticationException("Cannot find any subscriptions in current account.");
        }
        return new ArrayList<Subscription>(cliSubs);
    }

    @Override
    protected void setupAfterLogin(TokenCredential defaultTokenCredential) {
        List<Subscription> subscriptions = this.getSubscriptions();
        AzureCliSubscription defaultSub = (AzureCliSubscription)subscriptions.stream().filter(Subscription::isSelected).findFirst().orElse(subscriptions.get(0));
        AzureEnvironment configuredEnv = ((AzureCloud)Azure.az(AzureCloud.class)).get();
        if (configuredEnv != null && defaultSub.getEnvironment() != configuredEnv) {
            throw new AzureToolkitAuthenticationException(String.format("The azure cloud from azure cli '%s' doesn't match with your auth configuration, you can change it by executing 'az cloud set --name=%s' command to change the cloud in azure cli.", AzureEnvironmentUtils.getCloudName(defaultSub.getEnvironment()), AzureEnvironmentUtils.getCloudName(configuredEnv)));
        }
        this.username = defaultSub.getEmail();
    }

    @Override
    @Nonnull
    protected TokenCredential buildDefaultTokenCredential() {
        String tenantId = Optional.of(this.getConfig()).map(AuthConfiguration::getTenant).orElse(null);
        return new AzureCliTokenCredential(tenantId);
    }

    @Override
    public boolean checkAvailable() {
        try {
            boolean available = this.getManagementToken().isPresent();
            log.trace("Auth type ({}) is {}available.", (Object)TextUtils.cyan((String)this.getType().name()), (Object)(available ? "" : TextUtils.yellow((String)"NOT ")));
            return available;
        }
        catch (Throwable e) {
            return false;
        }
    }

    static boolean isInCloudShell() {
        return StringUtils.isNotBlank((CharSequence)System.getenv(CLOUD_SHELL_ENV_KEY));
    }

    @Override
    @Generated
    public AuthType getType() {
        return this.type;
    }

    @Override
    @Generated
    public String getUsername() {
        return this.username;
    }

    static class AzureCliTokenCredential
    implements TokenCredential {
        private static final String CLI_GET_ACCESS_TOKEN_CMD = "az account get-access-token --resource %s %s --output json";
        private final Map<String, SimpleTokenCache> tenantResourceTokenCache = new ConcurrentHashMap<String, SimpleTokenCache>();
        private final String tenantId;

        public Mono<AccessToken> getToken(TokenRequestContext request) {
            String tId = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{request.getTenantId(), this.tenantId});
            String scopes = ScopeUtil.scopesToResource((List)request.getScopes());
            String key = String.format("%s:%s", tId, scopes);
            return this.tenantResourceTokenCache.computeIfAbsent(key, k -> new SimpleTokenCache(() -> {
                String azCommand = String.format(CLI_GET_ACCESS_TOKEN_CMD, scopes, StringUtils.isBlank((CharSequence)tId) || AzureCliAccount.isInCloudShell() ? "" : " -t " + tId);
                TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
                Map result = (Map)JsonUtils.fromJson((String)AzureCliUtils.executeAzureCli(azCommand), (TypeReference)typeRef);
                String accessToken = (String)result.get("accessToken");
                OffsetDateTime expiresDateTime = Optional.ofNullable((String)result.get("expiresOn")).filter(StringUtils::isNotBlank).map(value -> value.substring(0, value.indexOf("."))).map(value -> String.join((CharSequence)"T", value.split(" "))).map(value -> LocalDateTime.parse(value, DateTimeFormatter.ISO_LOCAL_DATE_TIME).atZone(ZoneId.systemDefault()).toOffsetDateTime().withOffsetSameInstant(ZoneOffset.UTC)).orElse(OffsetDateTime.MAX);
                return Mono.just((Object)new AccessToken(accessToken, expiresDateTime));
            })).getToken();
        }

        @Generated
        public AzureCliTokenCredential(String tenantId) {
            this.tenantId = tenantId;
        }
    }
}

