/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.auth;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.SharedTokenCacheCredentialBuilder;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AuthConfiguration;
import com.microsoft.azure.toolkit.lib.auth.AuthType;
import com.microsoft.azure.toolkit.lib.common.utils.TextUtils;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedTokenCacheAccount
extends Account {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SharedTokenCacheAccount.class);

    public SharedTokenCacheAccount(@Nonnull AuthConfiguration config) {
        super(config);
    }

    @Override
    @Nonnull
    protected TokenCredential buildDefaultTokenCredential() {
        AuthConfiguration config = this.getConfig();
        return ((SharedTokenCacheCredentialBuilder)((SharedTokenCacheCredentialBuilder)new SharedTokenCacheCredentialBuilder().tokenCachePersistenceOptions(PERSISTENCE_OPTIONS).tenantId(config.getTenant())).username(config.getUsername()).clientId(config.getClient())).build();
    }

    @Override
    public boolean checkAvailable() {
        boolean available = this.getManagementToken().isPresent();
        log.trace("Auth type ({}) is {}available.", (Object)TextUtils.cyan((String)this.getType().name()), (Object)(available ? "" : TextUtils.yellow((String)"NOT ")));
        return available;
    }

    @Override
    public AuthType getType() {
        return this.getConfig().getType();
    }
}

