/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.legacy.function.handlers;

import com.microsoft.azure.toolkit.lib.appservice.function.core.FunctionAnnotation;
import com.microsoft.azure.toolkit.lib.appservice.function.core.FunctionMethod;
import com.microsoft.azure.toolkit.lib.appservice.function.impl.DefaultFunctionProject;
import com.microsoft.azure.toolkit.lib.common.exception.AzureExecutionException;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.legacy.function.bindings.Binding;
import com.microsoft.azure.toolkit.lib.legacy.function.bindings.BindingEnum;
import com.microsoft.azure.toolkit.lib.legacy.function.bindings.BindingFactory;
import com.microsoft.azure.toolkit.lib.legacy.function.configurations.FunctionConfiguration;
import com.microsoft.azure.toolkit.lib.legacy.function.configurations.Retry;
import com.microsoft.azure.toolkit.lib.legacy.function.handlers.AnnotationHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AnnotationHandlerImpl
implements AnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(AnnotationHandlerImpl.class);
    private static final String MULTI_RETRY_ANNOTATION = "Fixed delay retry and exponential backoff retry are not compatible, please use either of them for one trigger";

    @Override
    public Set<Method> findFunctions(List<URL> urls) {
        try {
            ClassLoader classLoader = this.getClassLoader(urls);
            Class functionNameAnnotation = ClassUtils.getClass((ClassLoader)classLoader, (String)"com.microsoft.azure.functions.annotation.FunctionName");
            ConfigurationBuilder builder = new ConfigurationBuilder().addUrls(urls).setScanners(new Scanner[]{Scanners.MethodsAnnotated}).addClassLoaders(new ClassLoader[]{classLoader});
            return new Reflections((Configuration)builder).getMethodsAnnotatedWith(functionNameAnnotation);
        }
        catch (ClassNotFoundException e) {
            throw new AzureToolkitRuntimeException((Throwable)e);
        }
    }

    protected ClassLoader getClassLoader(List<URL> urlList) {
        URL[] urlArray = urlList.toArray(new URL[0]);
        return new URLClassLoader(urlArray, this.getClass().getClassLoader());
    }

    @Override
    public Map<String, FunctionConfiguration> generateConfigurations(Set<Method> methods) throws AzureExecutionException {
        HashMap<String, FunctionConfiguration> configMap = new HashMap<String, FunctionConfiguration>();
        for (Method method : methods) {
            FunctionMethod functionMethod = DefaultFunctionProject.create(method);
            FunctionAnnotation functionNameAnnotation = functionMethod.getAnnotation("com.microsoft.azure.functions.annotation.FunctionName");
            if (functionNameAnnotation == null) continue;
            String functionName = functionNameAnnotation.getStringValue("value", true);
            this.validateFunctionName(configMap.keySet(), functionName);
            log.debug("Starting processing function : " + functionName);
            configMap.put(functionName, this.generateConfiguration(method));
        }
        return configMap;
    }

    protected void validateFunctionName(Set<String> nameSet, String functionName) throws AzureExecutionException {
        if (StringUtils.isEmpty((CharSequence)functionName)) {
            throw new AzureExecutionException("Azure Functions name cannot be empty.");
        }
        if (nameSet.stream().anyMatch(n -> StringUtils.equalsIgnoreCase((CharSequence)n, (CharSequence)functionName))) {
            throw new AzureExecutionException("Found duplicate Azure Function: " + functionName);
        }
    }

    @Override
    public FunctionConfiguration generateConfiguration(Method method) throws AzureExecutionException {
        FunctionConfiguration config = new FunctionConfiguration();
        List<Binding> bindings = config.getBindings();
        this.processParameterAnnotations(method, bindings);
        this.processMethodAnnotations(method, bindings);
        this.patchStorageBinding(method, bindings);
        config.setRetry(this.getRetryConfigurationFromMethod(method));
        config.setEntryPoint(method.getDeclaringClass().getCanonicalName() + "." + method.getName());
        return config;
    }

    private Retry getRetryConfigurationFromMethod(Method method) throws AzureExecutionException {
        FunctionMethod functionMethod = DefaultFunctionProject.create(method);
        FunctionAnnotation fixedDelayRetry = functionMethod.getAnnotation("com.microsoft.azure.functions.annotation.FixedDelayRetry");
        FunctionAnnotation exponentialBackoffRetry = functionMethod.getAnnotation("com.microsoft.azure.functions.annotation.ExponentialBackoffRetry");
        if (fixedDelayRetry != null && exponentialBackoffRetry != null) {
            throw new AzureExecutionException(MULTI_RETRY_ANNOTATION);
        }
        if (fixedDelayRetry != null) {
            return Retry.createFixedDelayRetryFromAnnotation(fixedDelayRetry);
        }
        if (exponentialBackoffRetry != null) {
            return Retry.createExponentialBackoffRetryFromAnnotation(exponentialBackoffRetry);
        }
        return null;
    }

    protected void processParameterAnnotations(Method method, List<Binding> bindings) {
        for (Parameter param : method.getParameters()) {
            bindings.addAll(this.parseAnnotations(param::getAnnotations, this::parseParameterAnnotation));
        }
    }

    protected void processMethodAnnotations(Method method, List<Binding> bindings) {
        if (!method.getReturnType().equals(Void.TYPE)) {
            bindings.addAll(this.parseAnnotations(method::getAnnotations, this::parseMethodAnnotation));
            if (bindings.stream().anyMatch(b -> b.getBindingEnum() == BindingEnum.HttpTrigger) && bindings.stream().noneMatch(b -> b.getName().equalsIgnoreCase("$return"))) {
                bindings.add(BindingFactory.getHTTPOutBinding());
            }
        }
    }

    protected List<Binding> parseAnnotations(Supplier<Annotation[]> annotationProvider, Function<Annotation, Binding> annotationParser) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        for (Annotation annotation : annotationProvider.get()) {
            Binding binding = annotationParser.apply(annotation);
            if (binding == null) continue;
            log.debug("Adding binding: " + binding);
            bindings.add(binding);
        }
        return bindings;
    }

    protected Binding parseParameterAnnotation(Annotation annotation) {
        return BindingFactory.getBinding(annotation);
    }

    protected Binding parseMethodAnnotation(Annotation annotation) {
        Binding ret = this.parseParameterAnnotation(annotation);
        if (ret != null) {
            ret.setName("$return");
        }
        return ret;
    }

    protected void patchStorageBinding(Method method, List<Binding> bindings) {
        FunctionMethod functionMethod = DefaultFunctionProject.create(method);
        FunctionAnnotation storageAccount = functionMethod.getAnnotation("com.microsoft.azure.functions.annotation.StorageAccount");
        if (storageAccount != null) {
            log.debug("StorageAccount annotation found.");
            String connectionString = storageAccount.getStringValue("value", true);
            bindings.stream().filter(binding -> binding.getBindingEnum().isStorage()).filter(binding -> StringUtils.isEmpty((CharSequence)((String)binding.getAttribute("connection")))).forEach(binding -> binding.setAttribute("connection", connectionString));
        } else {
            log.debug("No StorageAccount annotation found.");
        }
    }
}

