/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.utils;

import com.azure.resourcemanager.appservice.fluent.models.FunctionEnvelopeInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteLogsConfigInner;
import com.azure.resourcemanager.appservice.models.ApplicationLogsConfig;
import com.azure.resourcemanager.appservice.models.FileSystemApplicationLogsConfig;
import com.azure.resourcemanager.appservice.models.FileSystemHttpLogsConfig;
import com.azure.resourcemanager.appservice.models.FunctionEnvelope;
import com.azure.resourcemanager.appservice.models.HttpLogsConfig;
import com.azure.resourcemanager.appservice.models.KuduDeploymentResult;
import com.azure.resourcemanager.appservice.models.PricingTier;
import com.azure.resourcemanager.appservice.models.PublishingProfile;
import com.azure.resourcemanager.appservice.models.SkuDescription;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.appservice.models.WebAppDiagnosticLogs;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.microsoft.azure.toolkit.lib.appservice.entity.FunctionEntity;
import com.microsoft.azure.toolkit.lib.appservice.model.CsmDeploymentStatus;
import com.microsoft.azure.toolkit.lib.appservice.model.DeployOptions;
import com.microsoft.azure.toolkit.lib.appservice.model.DeploymentBuildStatus;
import com.microsoft.azure.toolkit.lib.appservice.model.DiagnosticConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.ErrorEntity;
import com.microsoft.azure.toolkit.lib.appservice.model.LogLevel;
import com.microsoft.azure.toolkit.lib.appservice.model.PublishingProfile;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;

public class AppServiceUtils {
    private static final String SCRIPT_FILE = "scriptFile";
    private static final String ENTRY_POINT = "entryPoint";
    private static final String BINDINGS = "bindings";

    public static com.microsoft.azure.toolkit.lib.appservice.model.PublishingProfile fromPublishingProfile(PublishingProfile publishingProfile) {
        return ((PublishingProfile.PublishingProfileBuilder)((PublishingProfile.PublishingProfileBuilder)((PublishingProfile.PublishingProfileBuilder)((PublishingProfile.PublishingProfileBuilder)((PublishingProfile.PublishingProfileBuilder)((PublishingProfile.PublishingProfileBuilder)com.microsoft.azure.toolkit.lib.appservice.model.PublishingProfile.builder().ftpUrl(publishingProfile.ftpUrl())).ftpUsername(publishingProfile.ftpUsername())).ftpPassword(publishingProfile.ftpPassword())).gitUrl(publishingProfile.gitUrl())).gitUsername(publishingProfile.gitUsername())).gitPassword(publishingProfile.gitPassword())).build();
    }

    public static PricingTier toPricingTier(com.microsoft.azure.toolkit.lib.appservice.model.PricingTier pricingTier) {
        SkuDescription skuDescription = new SkuDescription().withTier(pricingTier.getTier()).withSize(pricingTier.getSize());
        return PricingTier.fromSkuDescription((SkuDescription)skuDescription);
    }

    public static DiagnosticConfig fromWebAppDiagnosticLogs(WebAppDiagnosticLogs webAppDiagnosticLogs) {
        DiagnosticConfig.DiagnosticConfigBuilder builder = DiagnosticConfig.builder();
        com.azure.resourcemanager.appservice.models.LogLevel applicationLogLevel = Optional.ofNullable(webAppDiagnosticLogs).map(HasInnerModel::innerModel).map(SiteLogsConfigInner::applicationLogs).map(ApplicationLogsConfig::fileSystem).map(FileSystemApplicationLogsConfig::level).orElse(null);
        if (applicationLogLevel != null && applicationLogLevel != com.azure.resourcemanager.appservice.models.LogLevel.OFF) {
            builder.enableApplicationLog(true).applicationLogLevel(LogLevel.fromString(applicationLogLevel.toString()));
        } else {
            builder.enableApplicationLog(false);
        }
        FileSystemHttpLogsConfig httpLogsConfig = Optional.ofNullable(webAppDiagnosticLogs).map(HasInnerModel::innerModel).map(SiteLogsConfigInner::httpLogs).map(HttpLogsConfig::fileSystem).orElse(null);
        if (httpLogsConfig != null && httpLogsConfig.enabled().booleanValue()) {
            builder.enableWebServerLogging(true).webServerLogQuota(httpLogsConfig.retentionInMb()).webServerRetentionPeriod(httpLogsConfig.retentionInDays()).enableDetailedErrorMessage(webAppDiagnosticLogs.detailedErrorMessages()).enableFailedRequestTracing(webAppDiagnosticLogs.failedRequestsTracing());
        } else {
            builder.enableWebServerLogging(false);
        }
        return builder.build();
    }

    public static <T extends WebAppBase> void defineDiagnosticConfigurationForWebAppBase(WebAppBase.DefinitionStages.WithCreate<T> withCreate, DiagnosticConfig diagnosticConfig) {
        if (diagnosticConfig.isEnableApplicationLog()) {
            withCreate.defineDiagnosticLogsConfiguration().withApplicationLogging().withLogLevel(com.azure.resourcemanager.appservice.models.LogLevel.fromString((String)diagnosticConfig.getApplicationLogLevel().getValue())).withApplicationLogsStoredOnFileSystem().attach();
        }
        if (diagnosticConfig.isEnableWebServerLogging()) {
            withCreate.defineDiagnosticLogsConfiguration().withWebServerLogging().withWebServerLogsStoredOnFileSystem().withWebServerFileSystemQuotaInMB(((Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{diagnosticConfig.getWebServerLogQuota(), 0})).intValue()).withLogRetentionDays(((Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{diagnosticConfig.getWebServerRetentionPeriod(), 0})).intValue()).withDetailedErrorMessages(diagnosticConfig.isEnableDetailedErrorMessage()).withFailedRequestTracing(diagnosticConfig.isEnableFailedRequestTracing()).attach();
        }
    }

    public static <T extends WebAppBase> void updateDiagnosticConfigurationForWebAppBase(WebAppBase.Update<T> update, DiagnosticConfig diagnosticConfig) {
        WebAppDiagnosticLogs.UpdateStages.Blank blank = update.updateDiagnosticLogsConfiguration();
        if (diagnosticConfig.isEnableApplicationLog()) {
            blank.withApplicationLogging().withLogLevel(com.azure.resourcemanager.appservice.models.LogLevel.fromString((String)diagnosticConfig.getApplicationLogLevel().getValue())).withApplicationLogsStoredOnFileSystem().parent();
        } else {
            blank.withoutApplicationLogging().parent();
        }
        if (diagnosticConfig.isEnableWebServerLogging()) {
            blank.withWebServerLogging().withWebServerLogsStoredOnFileSystem().withWebServerFileSystemQuotaInMB(((Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{diagnosticConfig.getWebServerLogQuota(), 0})).intValue()).withLogRetentionDays(((Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{diagnosticConfig.getWebServerRetentionPeriod(), 0})).intValue()).withDetailedErrorMessages(diagnosticConfig.isEnableDetailedErrorMessage()).withFailedRequestTracing(diagnosticConfig.isEnableFailedRequestTracing()).parent();
        } else {
            blank.withoutWebServerLogging().parent();
        }
    }

    public static FunctionEntity fromFunctionAppEnvelope(@Nonnull FunctionEnvelope functionEnvelope, @Nonnull String functionId) {
        Object config = functionEnvelope.config();
        if (!(config instanceof Map)) {
            return null;
        }
        Map envelopeConfigMap = (Map)config;
        String scriptFile = (String)envelopeConfigMap.get(SCRIPT_FILE);
        String entryPoint = (String)envelopeConfigMap.get(ENTRY_POINT);
        Object bindingListObject = envelopeConfigMap.get(BINDINGS);
        List<FunctionEntity.BindingEntity> bindingEntities = Optional.ofNullable(bindingListObject instanceof List ? (List)bindingListObject : null).map(list -> list.stream().filter(item -> item instanceof Map).map(map -> AppServiceUtils.fromJsonBinding((Map)map)).collect(Collectors.toList())).orElse(Collections.emptyList());
        return ((FunctionEntity.FunctionEntityBuilder)((FunctionEntity.FunctionEntityBuilder)((FunctionEntity.FunctionEntityBuilder)((FunctionEntity.FunctionEntityBuilder)((FunctionEntity.FunctionEntityBuilder)((FunctionEntity.FunctionEntityBuilder)((FunctionEntity.FunctionEntityBuilder)FunctionEntity.builder().name(AppServiceUtils.getFunctionTriggerName(functionEnvelope))).entryPoint(entryPoint)).scriptFile(scriptFile)).bindingList(bindingEntities)).functionAppId(functionId)).triggerId(((FunctionEnvelopeInner)functionEnvelope.innerModel()).id())).triggerUrl(((FunctionEnvelopeInner)functionEnvelope.innerModel()).invokeUrlTemplate())).build();
    }

    private static String getFunctionTriggerName(@Nonnull FunctionEnvelope functionEnvelope) {
        String fullName = ((FunctionEnvelopeInner)functionEnvelope.innerModel()).name();
        String[] splitNames = fullName.split("/");
        return splitNames.length > 1 ? splitNames[1] : fullName;
    }

    private static FunctionEntity.BindingEntity fromJsonBinding(Map<String, String> bindingProperties) {
        return ((FunctionEntity.BindingEntity.BindingEntityBuilder)((FunctionEntity.BindingEntity.BindingEntityBuilder)((FunctionEntity.BindingEntity.BindingEntityBuilder)((FunctionEntity.BindingEntity.BindingEntityBuilder)FunctionEntity.BindingEntity.builder().type(bindingProperties.get("type"))).direction(bindingProperties.get("direction"))).name(bindingProperties.get("name"))).properties(bindingProperties)).build();
    }

    public static com.azure.resourcemanager.appservice.models.DeployOptions toDeployOptions(@Nonnull DeployOptions deployOptions) {
        return new com.azure.resourcemanager.appservice.models.DeployOptions().withPath(deployOptions.getPath()).withCleanDeployment(deployOptions.getCleanDeployment()).withRestartSite(deployOptions.getRestartSite()).withTrackDeployment(deployOptions.getTrackDeployment());
    }

    public static com.microsoft.azure.toolkit.lib.appservice.model.KuduDeploymentResult fromKuduDeploymentResult(@Nonnull KuduDeploymentResult result) {
        return com.microsoft.azure.toolkit.lib.appservice.model.KuduDeploymentResult.builder().deploymentId(result.deploymentId()).build();
    }

    public static CsmDeploymentStatus fromCsmDeploymentStatus(@Nonnull com.azure.resourcemanager.appservice.models.CsmDeploymentStatus deploymentStatus) {
        DeploymentBuildStatus buildStatus = DeploymentBuildStatus.fromString(deploymentStatus.status().toString());
        List<ErrorEntity> errors = Optional.ofNullable(deploymentStatus.errors()).map(list -> list.stream().map(AppServiceUtils::fromErrorEntity).collect(Collectors.toList())).orElse(Collections.emptyList());
        return CsmDeploymentStatus.builder().deploymentId(deploymentStatus.deploymentId()).status(buildStatus).errors(errors).numberOfInstancesSuccessful(deploymentStatus.numberOfInstancesSuccessful()).numberOfInstancesFailed(deploymentStatus.numberOfInstancesFailed()).numberOfInstancesInProgress(deploymentStatus.numberOfInstancesInProgress()).failedInstancesLogs(deploymentStatus.failedInstancesLogs()).build();
    }

    private static ErrorEntity fromErrorEntity(@Nonnull com.azure.resourcemanager.appservice.models.ErrorEntity entity) {
        List<ErrorEntity> details = Optional.ofNullable(entity.details()).map(list -> list.stream().map(AppServiceUtils::fromErrorEntity).collect(Collectors.toList())).orElse(Collections.emptyList());
        List<ErrorEntity> innerErrors = Optional.ofNullable(entity.innerErrors()).map(list -> list.stream().map(AppServiceUtils::fromErrorEntity).collect(Collectors.toList())).orElse(Collections.emptyList());
        return ErrorEntity.builder().details(details).innerErrors(innerErrors).code(entity.code()).extendedCode(entity.extendedCode()).message(entity.message()).messageTemplate(entity.messageTemplate()).parameters(entity.parameters()).target(entity.target()).build();
    }
}

