/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.model;

import com.azure.resourcemanager.appservice.models.FunctionAppMajorVersion;
import com.azure.resourcemanager.appservice.models.FunctionAppMinorVersion;
import com.azure.resourcemanager.appservice.models.FunctionAppRuntimeSettings;
import com.azure.resourcemanager.appservice.models.FunctionAppRuntimes;
import com.azure.resourcemanager.appservice.models.FunctionRuntimeStack;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionAppRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.utils.Utils;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class FunctionAppLinuxRuntime
implements FunctionAppRuntime {
    public static final FunctionAppLinuxRuntime FUNCTION_JAVA21 = new FunctionAppLinuxRuntime("Java|21");
    public static final FunctionAppLinuxRuntime FUNCTION_JAVA17 = new FunctionAppLinuxRuntime("Java|17");
    public static final FunctionAppLinuxRuntime FUNCTION_JAVA11 = new FunctionAppLinuxRuntime("Java|11");
    public static final FunctionAppLinuxRuntime FUNCTION_JAVA8 = new FunctionAppLinuxRuntime("Java|8");
    private static final LinkedHashSet<FunctionAppLinuxRuntime> RUNTIMES = new LinkedHashSet<FunctionAppLinuxRuntime>(Arrays.asList(FUNCTION_JAVA17, FUNCTION_JAVA11, FUNCTION_JAVA8, FUNCTION_JAVA21));
    private static final AtomicReference<Boolean> loaded = new AtomicReference<Boolean>(Boolean.FALSE);
    private final String fxString;
    private final OperatingSystem operatingSystem = OperatingSystem.LINUX;
    @Nonnull
    private final String javaVersionNumber;
    private final boolean deprecated;
    private final boolean hidden;
    private final boolean earlyAccess;
    private final boolean autoUpdate;
    private final boolean preview;
    @Nullable
    private final OffsetDateTime endOfLifeDate;

    private FunctionAppLinuxRuntime(@Nonnull FunctionAppMinorVersion javaVersion) {
        FunctionAppRuntimeSettings settings = javaVersion.stackSettings().linuxRuntimeSettings();
        this.fxString = settings.runtimeVersion();
        this.javaVersionNumber = Runtime.extractAndFormalizeJavaVersionNumber(this.fxString.split("\\|", 2)[1]);
        this.deprecated = BooleanUtils.isTrue((Boolean)settings.isDeprecated());
        this.hidden = BooleanUtils.isTrue((Boolean)settings.isHidden());
        this.earlyAccess = BooleanUtils.isTrue((Boolean)settings.isEarlyAccess());
        this.autoUpdate = BooleanUtils.isTrue((Boolean)settings.isAutoUpdate());
        this.preview = BooleanUtils.isTrue((Boolean)settings.isPreview());
        this.endOfLifeDate = settings.endOfLifeDate();
    }

    private FunctionAppLinuxRuntime(Map<String, Object> javaVersion) {
        Map settings = (Map)Utils.get(javaVersion, (String)"$.stackSettings.linuxRuntimeSettings");
        this.fxString = (String)Utils.get((Map)settings, (String)"$.runtimeVersion");
        this.javaVersionNumber = Runtime.extractAndFormalizeJavaVersionNumber(Objects.requireNonNull(this.fxString).split("\\|", 2)[1]);
        this.deprecated = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)settings, (String)"$.isDeprecated")));
        this.hidden = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)settings, (String)"$.isHidden")));
        this.earlyAccess = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)settings, (String)"$.isEarlyAccess")));
        this.autoUpdate = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)settings, (String)"$.isAutoUpdate")));
        this.preview = BooleanUtils.isTrue((Boolean)((Boolean)Utils.get((Map)settings, (String)"$.isPreview")));
        CharSequence endOfLifeDateStr = (CharSequence)Utils.get((Map)settings, (String)"$.endOfLifeDate");
        this.endOfLifeDate = StringUtils.isBlank((CharSequence)endOfLifeDateStr) ? null : OffsetDateTime.parse(endOfLifeDateStr, DateTimeFormatter.ISO_ZONED_DATE_TIME);
    }

    private FunctionAppLinuxRuntime(@Nonnull String fxString) {
        this.fxString = fxString;
        this.javaVersionNumber = Runtime.extractAndFormalizeJavaVersionNumber(this.fxString.split("\\|", 2)[1]);
        this.deprecated = false;
        this.hidden = false;
        this.earlyAccess = false;
        this.autoUpdate = false;
        this.preview = false;
        this.endOfLifeDate = null;
    }

    public FunctionRuntimeStack toFunctionRuntimeStack(String funcExtensionVersion) {
        return new FunctionRuntimeStack("java", funcExtensionVersion, this.fxString.toLowerCase());
    }

    @Nullable
    public static FunctionAppLinuxRuntime fromFxString(String fxString) {
        return FunctionAppLinuxRuntime.getAllRuntimes().stream().filter(runtime -> StringUtils.equalsIgnoreCase((CharSequence)fxString, (CharSequence)runtime.fxString)).findFirst().orElse(null);
    }

    @Nullable
    public static FunctionAppLinuxRuntime fromJavaVersionUserText(String v) {
        if (StringUtils.isBlank((CharSequence)v)) {
            v = "Java 17";
            AzureMessager.getMessager().warning(AzureString.format((String)"The java version is not specified, use default version '%s'", (Object[])new Object[]{"Java 17"}));
        }
        String javaVersionNumber = Runtime.extractAndFormalizeJavaVersionNumber(v);
        return FunctionAppLinuxRuntime.getAllRuntimes().stream().filter(runtime -> StringUtils.equalsIgnoreCase((CharSequence)runtime.javaVersionNumber, (CharSequence)javaVersionNumber)).findFirst().orElse(null);
    }

    public static List<FunctionAppLinuxRuntime> getAllRuntimes() {
        FunctionAppRuntime.tryLoadingAllRuntimes();
        return new ArrayList<FunctionAppLinuxRuntime>(RUNTIMES);
    }

    @Nonnull
    public static List<FunctionAppLinuxRuntime> getMajorRuntimes() {
        return FunctionAppLinuxRuntime.getAllRuntimes().stream().filter(r -> !r.isDeprecated() && !r.isHidden() && r.isMajorVersion()).collect(Collectors.toList());
    }

    public static boolean isLoaded() {
        return loaded.get() == Boolean.TRUE;
    }

    public static boolean isLoading() {
        return loaded.get() == null;
    }

    public static void loadAllFunctionAppLinuxRuntimes(List<FunctionAppMajorVersion> javaVersions) {
        if (!loaded.compareAndSet(Boolean.FALSE, null)) {
            return;
        }
        Pattern EXCLUDE_PATTERN = Pattern.compile("\\..*\\.");
        List<FunctionAppMinorVersion> javaMinorVersions = javaVersions.stream().flatMap(majorVersion -> majorVersion.minorVersions().stream().filter(minorVersion -> !EXCLUDE_PATTERN.matcher(minorVersion.value()).matches())).collect(Collectors.toList());
        RUNTIMES.clear();
        javaMinorVersions.forEach(javaMinorVersion -> Optional.ofNullable(javaMinorVersion).map(FunctionAppMinorVersion::stackSettings).map(FunctionAppRuntimes::linuxRuntimeSettings).map(FunctionAppRuntimeSettings::runtimeVersion).ifPresent(s -> RUNTIMES.add(new FunctionAppLinuxRuntime((FunctionAppMinorVersion)javaMinorVersion))));
        loaded.compareAndSet(null, Boolean.TRUE);
    }

    public static void loadAllFunctionAppLinuxRuntimesFromMap(List<Map<String, Object>> javaVersions) {
        if (!loaded.compareAndSet(Boolean.FALSE, null)) {
            return;
        }
        Pattern EXCLUDE_PATTERN = Pattern.compile("\\..*\\.");
        List<Map> javaMinorVersions = javaVersions.stream().flatMap(majorVersion -> ((List)Utils.get((Map)majorVersion, (String)"$.minorVersions")).stream().filter(minorVersion -> !EXCLUDE_PATTERN.matcher((CharSequence)Utils.get((Map)minorVersion, (String)"$.value")).matches())).collect(Collectors.toList());
        RUNTIMES.clear();
        javaMinorVersions.forEach(javaMinorVersion -> {
            String runtimeVersion = (String)Utils.get((Map)javaMinorVersion, (String)"$.stackSettings.linuxRuntimeSettings.runtimeVersion");
            if (StringUtils.isNotBlank((CharSequence)runtimeVersion)) {
                RUNTIMES.add(new FunctionAppLinuxRuntime((Map<String, Object>)javaMinorVersion));
            }
        });
        loaded.compareAndSet(null, Boolean.TRUE);
    }

    public String toString() {
        return String.format("Linux | %s", this.getJavaVersionUserText());
    }

    public String getFxString() {
        return this.fxString;
    }

    @Override
    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    @Override
    @Nonnull
    public String getJavaVersionNumber() {
        return this.javaVersionNumber;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean isEarlyAccess() {
        return this.earlyAccess;
    }

    @Override
    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    @Override
    public boolean isPreview() {
        return this.preview;
    }

    @Override
    @Nullable
    public OffsetDateTime getEndOfLifeDate() {
        return this.endOfLifeDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionAppLinuxRuntime)) {
            return false;
        }
        FunctionAppLinuxRuntime other = (FunctionAppLinuxRuntime)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OperatingSystem this$operatingSystem = this.getOperatingSystem();
        OperatingSystem other$operatingSystem = other.getOperatingSystem();
        if (this$operatingSystem == null ? other$operatingSystem != null : !((Object)((Object)this$operatingSystem)).equals((Object)other$operatingSystem)) {
            return false;
        }
        String this$javaVersionNumber = this.getJavaVersionNumber();
        String other$javaVersionNumber = other.getJavaVersionNumber();
        return !(this$javaVersionNumber == null ? other$javaVersionNumber != null : !this$javaVersionNumber.equals(other$javaVersionNumber));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FunctionAppLinuxRuntime;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OperatingSystem $operatingSystem = this.getOperatingSystem();
        result = result * 59 + ($operatingSystem == null ? 43 : ((Object)((Object)$operatingSystem)).hashCode());
        String $javaVersionNumber = this.getJavaVersionNumber();
        result = result * 59 + ($javaVersionNumber == null ? 43 : $javaVersionNumber.hashCode());
        return result;
    }
}

