/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.model;

import com.azure.resourcemanager.appservice.models.FunctionApp;
import javax.annotation.Nonnull;

public class ContainerAppFunctionConfiguration {
    protected Integer minReplicas;
    protected Integer maxReplicas;

    public static ContainerAppFunctionConfiguration fromFunctionApp(@Nonnull FunctionApp app) {
        return ContainerAppFunctionConfiguration.builder().minReplicas(app.minReplicas()).minReplicas(app.maxReplicas()).build();
    }

    public static ContainerAppFunctionConfigurationBuilder builder() {
        return new ContainerAppFunctionConfigurationBuilder();
    }

    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    public void setMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
    }

    public void setMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
    }

    public ContainerAppFunctionConfiguration() {
    }

    public ContainerAppFunctionConfiguration(Integer minReplicas, Integer maxReplicas) {
        this.minReplicas = minReplicas;
        this.maxReplicas = maxReplicas;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainerAppFunctionConfiguration)) {
            return false;
        }
        ContainerAppFunctionConfiguration other = (ContainerAppFunctionConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$minReplicas = this.getMinReplicas();
        Integer other$minReplicas = other.getMinReplicas();
        if (this$minReplicas == null ? other$minReplicas != null : !((Object)this$minReplicas).equals(other$minReplicas)) {
            return false;
        }
        Integer this$maxReplicas = this.getMaxReplicas();
        Integer other$maxReplicas = other.getMaxReplicas();
        return !(this$maxReplicas == null ? other$maxReplicas != null : !((Object)this$maxReplicas).equals(other$maxReplicas));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContainerAppFunctionConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $minReplicas = this.getMinReplicas();
        result = result * 59 + ($minReplicas == null ? 43 : ((Object)$minReplicas).hashCode());
        Integer $maxReplicas = this.getMaxReplicas();
        result = result * 59 + ($maxReplicas == null ? 43 : ((Object)$maxReplicas).hashCode());
        return result;
    }

    public static class ContainerAppFunctionConfigurationBuilder {
        private Integer minReplicas;
        private Integer maxReplicas;

        ContainerAppFunctionConfigurationBuilder() {
        }

        public ContainerAppFunctionConfigurationBuilder minReplicas(Integer minReplicas) {
            this.minReplicas = minReplicas;
            return this;
        }

        public ContainerAppFunctionConfigurationBuilder maxReplicas(Integer maxReplicas) {
            this.maxReplicas = maxReplicas;
            return this;
        }

        public ContainerAppFunctionConfiguration build() {
            return new ContainerAppFunctionConfiguration(this.minReplicas, this.maxReplicas);
        }

        public String toString() {
            return "ContainerAppFunctionConfiguration.ContainerAppFunctionConfigurationBuilder(minReplicas=" + this.minReplicas + ", maxReplicas=" + this.maxReplicas + ")";
        }
    }
}

