/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice;

import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.task.AzureTaskManager;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AppServiceResourceModule<T extends AppServiceAppBase<T, P, R>, P extends AbstractAzResource<P, ?, ?>, R extends WebAppBase>
extends AbstractAzResourceModule<T, P, R> {
    private static final Logger log = LoggerFactory.getLogger(AppServiceResourceModule.class);

    public AppServiceResourceModule(@Nonnull String name, @Nonnull P parent) {
        super(name, parent);
    }

    protected Map<String, R> getResourcesFromAzure() {
        HashMap result = new HashMap();
        this.loadResourceIdsFromAzure().forEach(id -> result.put(id, null));
        return result;
    }

    protected void addResources(Map<String, R> loadedResources) {
        Set<String> added = loadedResources.keySet();
        log.debug("[{}]:reload().added={}", (Object)this.getName(), added);
        loadedResources.entrySet().stream().map(this::convertToResourcePair).sorted(Comparator.comparing(p -> ((AppServiceAppBase)((Object)((Object)p.getValue()))).getName())).forEach(p -> {
            WebAppBase remote = (WebAppBase)p.getKey();
            AppServiceAppBase resource = (AppServiceAppBase)((Object)((Object)p.getValue()));
            Runnable runnable = Objects.nonNull(remote) ? () -> resource.setRemote(remote) : () -> ((AppServiceAppBase)resource).refresh();
            AzureTaskManager.getInstance().runOnPooledThread(runnable);
            this.addResourceToLocal(resource.getId(), resource, new boolean[]{true});
        });
        this.syncTimeRef.set(System.currentTimeMillis());
    }

    protected Pair<R, T> convertToResourcePair(@Nonnull Map.Entry<String, R> entry) {
        String key = entry.getKey();
        ResourceId resourceId = ResourceId.fromString((String)key);
        WebAppBase value = (WebAppBase)entry.getValue();
        AppServiceAppBase result = Objects.nonNull(value) ? (AppServiceAppBase)this.newResource(value) : (AppServiceAppBase)this.newResource(resourceId.name(), resourceId.resourceGroupName());
        return Pair.of((Object)value, (Object)((Object)result));
    }

    protected abstract List<String> loadResourceIdsFromAzure();
}

