/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.azure.management.sql.CheckNameAvailabilityResult;
import com.microsoft.azure.management.sql.RegionCapabilities;
import com.microsoft.azure.management.sql.SqlDatabaseOperations;
import com.microsoft.azure.management.sql.SqlElasticPoolOperations;
import com.microsoft.azure.management.sql.SqlEncryptionProtectorOperations;
import com.microsoft.azure.management.sql.SqlFirewallRuleOperations;
import com.microsoft.azure.management.sql.SqlServer;
import com.microsoft.azure.management.sql.SqlServerKeyOperations;
import com.microsoft.azure.management.sql.SqlServers;
import com.microsoft.azure.management.sql.SqlSubscriptionUsageMetric;
import com.microsoft.azure.management.sql.SqlSyncGroupOperations;
import com.microsoft.azure.management.sql.SqlSyncMemberOperations;
import com.microsoft.azure.management.sql.SqlVirtualNetworkRuleOperations;
import com.microsoft.azure.management.sql.implementation.CheckNameAvailabilityResponseInner;
import com.microsoft.azure.management.sql.implementation.CheckNameAvailabilityResultImpl;
import com.microsoft.azure.management.sql.implementation.LocationCapabilitiesInner;
import com.microsoft.azure.management.sql.implementation.RegionCapabilitiesImpl;
import com.microsoft.azure.management.sql.implementation.ServerInner;
import com.microsoft.azure.management.sql.implementation.ServersInner;
import com.microsoft.azure.management.sql.implementation.SqlDatabaseOperationsImpl;
import com.microsoft.azure.management.sql.implementation.SqlElasticPoolOperationsImpl;
import com.microsoft.azure.management.sql.implementation.SqlEncryptionProtectorOperationsImpl;
import com.microsoft.azure.management.sql.implementation.SqlFailoverGroupOperationsImpl;
import com.microsoft.azure.management.sql.implementation.SqlFirewallRuleOperationsImpl;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerDnsAliasOperationsImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerKeyOperationsImpl;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import com.microsoft.azure.management.sql.implementation.SqlSubscriptionUsageMetricImpl;
import com.microsoft.azure.management.sql.implementation.SqlSyncGroupOperationsImpl;
import com.microsoft.azure.management.sql.implementation.SqlSyncMemberOperationsImpl;
import com.microsoft.azure.management.sql.implementation.SqlVirtualNetworkRuleOperationsImpl;
import com.microsoft.azure.management.sql.implementation.SubscriptionUsageInner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class SqlServersImpl
extends TopLevelModifiableResourcesImpl<SqlServer, SqlServerImpl, ServerInner, ServersInner, SqlServerManager>
implements SqlServers {
    private SqlFirewallRuleOperations firewallRules;
    private SqlVirtualNetworkRuleOperations virtualNetworkRules;
    private SqlElasticPoolOperations elasticPools;
    private SqlDatabaseOperations databases;
    private SqlServerDnsAliasOperationsImpl dnsAliases;
    private SqlFailoverGroupOperationsImpl failoverGroups;
    private SqlServerKeyOperationsImpl serverKeys;
    private SqlEncryptionProtectorOperationsImpl encryptionProtectors;
    private SqlSyncGroupOperationsImpl syncGroups;
    private SqlSyncMemberOperationsImpl syncMembers;

    protected SqlServersImpl(SqlServerManager manager) {
        super((InnerSupportsListing)((SqlManagementClientImpl)((Object)manager.inner())).servers(), (ManagerBase)manager);
    }

    protected SqlServerImpl wrapModel(String name) {
        ServerInner inner = new ServerInner();
        return new SqlServerImpl(name, inner, (SqlServerManager)this.manager());
    }

    protected SqlServerImpl wrapModel(ServerInner inner) {
        if (inner == null) {
            return null;
        }
        return new SqlServerImpl(inner.name(), inner, (SqlServerManager)this.manager());
    }

    public SqlServer.DefinitionStages.Blank define(String name) {
        return this.wrapModel(name);
    }

    @Override
    public SqlFirewallRuleOperations firewallRules() {
        if (this.firewallRules == null) {
            this.firewallRules = new SqlFirewallRuleOperationsImpl((SqlServerManager)this.manager());
        }
        return this.firewallRules;
    }

    @Override
    public SqlVirtualNetworkRuleOperations virtualNetworkRules() {
        if (this.virtualNetworkRules == null) {
            this.virtualNetworkRules = new SqlVirtualNetworkRuleOperationsImpl((SqlServerManager)this.manager());
        }
        return this.virtualNetworkRules;
    }

    @Override
    public SqlServerDnsAliasOperationsImpl dnsAliases() {
        if (this.dnsAliases == null) {
            this.dnsAliases = new SqlServerDnsAliasOperationsImpl((SqlServerManager)this.manager());
        }
        return this.dnsAliases;
    }

    @Override
    public SqlFailoverGroupOperationsImpl failoverGroups() {
        if (this.failoverGroups == null) {
            this.failoverGroups = new SqlFailoverGroupOperationsImpl((SqlServerManager)this.manager());
        }
        return this.failoverGroups;
    }

    @Override
    public SqlServerKeyOperations serverKeys() {
        if (this.serverKeys == null) {
            this.serverKeys = new SqlServerKeyOperationsImpl((SqlServerManager)this.manager());
        }
        return this.serverKeys;
    }

    @Override
    public SqlEncryptionProtectorOperations encryptionProtectors() {
        if (this.encryptionProtectors == null) {
            this.encryptionProtectors = new SqlEncryptionProtectorOperationsImpl((SqlServerManager)this.manager());
        }
        return this.encryptionProtectors;
    }

    @Override
    public SqlSyncGroupOperations syncGroups() {
        if (this.syncGroups == null) {
            this.syncGroups = new SqlSyncGroupOperationsImpl((SqlServerManager)this.manager());
        }
        return this.syncGroups;
    }

    @Override
    public SqlSyncMemberOperations syncMembers() {
        if (this.syncMembers == null) {
            this.syncMembers = new SqlSyncMemberOperationsImpl((SqlServerManager)this.manager());
        }
        return this.syncMembers;
    }

    @Override
    public SqlElasticPoolOperations elasticPools() {
        if (this.elasticPools == null) {
            this.elasticPools = new SqlElasticPoolOperationsImpl((SqlServerManager)this.manager());
        }
        return this.elasticPools;
    }

    @Override
    public SqlDatabaseOperations databases() {
        if (this.databases == null) {
            this.databases = new SqlDatabaseOperationsImpl((SqlServerManager)this.manager());
        }
        return this.databases;
    }

    @Override
    public CheckNameAvailabilityResult checkNameAvailability(String name) {
        return new CheckNameAvailabilityResultImpl(((ServersInner)this.inner()).checkNameAvailability(name));
    }

    @Override
    public Observable<CheckNameAvailabilityResult> checkNameAvailabilityAsync(String name) {
        return ((ServersInner)this.inner()).checkNameAvailabilityAsync(name).map((Func1)new Func1<CheckNameAvailabilityResponseInner, CheckNameAvailabilityResult>(){

            public CheckNameAvailabilityResult call(CheckNameAvailabilityResponseInner checkNameAvailabilityResponseInner) {
                return new CheckNameAvailabilityResultImpl(checkNameAvailabilityResponseInner);
            }
        });
    }

    @Override
    public RegionCapabilities getCapabilitiesByRegion(Region region) {
        LocationCapabilitiesInner capabilitiesInner = ((SqlManagementClientImpl)((Object)((SqlServerManager)this.manager()).inner())).capabilities().listByLocation(region.name());
        return capabilitiesInner != null ? new RegionCapabilitiesImpl(capabilitiesInner) : null;
    }

    @Override
    public Observable<RegionCapabilities> getCapabilitiesByRegionAsync(Region region) {
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)this.manager()).inner())).capabilities().listByLocationAsync(region.name()).map((Func1)new Func1<LocationCapabilitiesInner, RegionCapabilities>(){

            public RegionCapabilities call(LocationCapabilitiesInner capabilitiesInner) {
                return new RegionCapabilitiesImpl(capabilitiesInner);
            }
        });
    }

    @Override
    public List<SqlSubscriptionUsageMetric> listUsageByRegion(Region region) {
        Objects.requireNonNull(region);
        ArrayList<SqlSubscriptionUsageMetricImpl> subscriptionUsages = new ArrayList<SqlSubscriptionUsageMetricImpl>();
        PagedList<SubscriptionUsageInner> subscriptionUsageInners = ((SqlManagementClientImpl)((Object)((SqlServerManager)this.manager()).inner())).subscriptionUsages().listByLocation(region.name());
        if (subscriptionUsageInners != null) {
            for (SubscriptionUsageInner inner : subscriptionUsageInners) {
                subscriptionUsages.add(new SqlSubscriptionUsageMetricImpl(region.name(), inner, (SqlServerManager)this.manager()));
            }
        }
        return Collections.unmodifiableList(subscriptionUsages);
    }

    @Override
    public Observable<SqlSubscriptionUsageMetric> listUsageByRegionAsync(final Region region) {
        Objects.requireNonNull(region);
        final SqlServersImpl self = this;
        return ((SqlManagementClientImpl)((Object)((SqlServerManager)this.manager()).inner())).subscriptionUsages().listByLocationAsync(region.name()).flatMap((Func1)new Func1<Page<SubscriptionUsageInner>, Observable<SubscriptionUsageInner>>(){

            public Observable<SubscriptionUsageInner> call(Page<SubscriptionUsageInner> subscriptionUsageInnerPage) {
                return Observable.from((Iterable)subscriptionUsageInnerPage.items());
            }
        }).map((Func1)new Func1<SubscriptionUsageInner, SqlSubscriptionUsageMetric>(){

            public SqlSubscriptionUsageMetric call(SubscriptionUsageInner subscriptionUsageInner) {
                return new SqlSubscriptionUsageMetricImpl(region.name(), subscriptionUsageInner, (SqlServerManager)((Object)self.manager()));
            }
        });
    }
}

