/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.search.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.search.implementation.PageImpl;
import com.microsoft.azure.management.search.implementation.QueryKeyInner;
import com.microsoft.azure.management.search.implementation.SearchManagementClientImpl;
import com.microsoft.azure.management.search.implementation.SearchManagementRequestOptionsInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class QueryKeysInner {
    private QueryKeysService service;
    private SearchManagementClientImpl client;

    public QueryKeysInner(Retrofit retrofit, SearchManagementClientImpl client) {
        this.service = (QueryKeysService)retrofit.create(QueryKeysService.class);
        this.client = client;
    }

    public QueryKeyInner create(String resourceGroupName, String searchServiceName, String name) {
        return (QueryKeyInner)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, searchServiceName, name).toBlocking().single()).body();
    }

    public ServiceFuture<QueryKeyInner> createAsync(String resourceGroupName, String searchServiceName, String name, ServiceCallback<QueryKeyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, searchServiceName, name), serviceCallback);
    }

    public Observable<QueryKeyInner> createAsync(String resourceGroupName, String searchServiceName, String name) {
        return this.createWithServiceResponseAsync(resourceGroupName, searchServiceName, name).map((Func1)new Func1<ServiceResponse<QueryKeyInner>, QueryKeyInner>(){

            public QueryKeyInner call(ServiceResponse<QueryKeyInner> response) {
                return (QueryKeyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<QueryKeyInner>> createWithServiceResponseAsync(String resourceGroupName, String searchServiceName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (searchServiceName == null) {
            throw new IllegalArgumentException("Parameter searchServiceName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object searchManagementRequestOptions = null;
        UUID clientRequestId = null;
        return this.service.create(resourceGroupName, searchServiceName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), clientRequestId, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<QueryKeyInner>>>(){

            public Observable<ServiceResponse<QueryKeyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = QueryKeysInner.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public QueryKeyInner create(String resourceGroupName, String searchServiceName, String name, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        return (QueryKeyInner)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, searchServiceName, name, searchManagementRequestOptions).toBlocking().single()).body();
    }

    public ServiceFuture<QueryKeyInner> createAsync(String resourceGroupName, String searchServiceName, String name, SearchManagementRequestOptionsInner searchManagementRequestOptions, ServiceCallback<QueryKeyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, searchServiceName, name, searchManagementRequestOptions), serviceCallback);
    }

    public Observable<QueryKeyInner> createAsync(String resourceGroupName, String searchServiceName, String name, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        return this.createWithServiceResponseAsync(resourceGroupName, searchServiceName, name, searchManagementRequestOptions).map((Func1)new Func1<ServiceResponse<QueryKeyInner>, QueryKeyInner>(){

            public QueryKeyInner call(ServiceResponse<QueryKeyInner> response) {
                return (QueryKeyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<QueryKeyInner>> createWithServiceResponseAsync(String resourceGroupName, String searchServiceName, String name, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (searchServiceName == null) {
            throw new IllegalArgumentException("Parameter searchServiceName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)searchManagementRequestOptions);
        UUID clientRequestId = null;
        if (searchManagementRequestOptions != null) {
            clientRequestId = searchManagementRequestOptions.clientRequestId();
        }
        return this.service.create(resourceGroupName, searchServiceName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), clientRequestId, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<QueryKeyInner>>>(){

            public Observable<ServiceResponse<QueryKeyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = QueryKeysInner.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<QueryKeyInner> createDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<QueryKeyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<QueryKeyInner> listBySearchService(String resourceGroupName, String searchServiceName) {
        return (List)((ServiceResponse)this.listBySearchServiceWithServiceResponseAsync(resourceGroupName, searchServiceName).toBlocking().single()).body();
    }

    public ServiceFuture<List<QueryKeyInner>> listBySearchServiceAsync(String resourceGroupName, String searchServiceName, ServiceCallback<List<QueryKeyInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listBySearchServiceWithServiceResponseAsync(resourceGroupName, searchServiceName), serviceCallback);
    }

    public Observable<List<QueryKeyInner>> listBySearchServiceAsync(String resourceGroupName, String searchServiceName) {
        return this.listBySearchServiceWithServiceResponseAsync(resourceGroupName, searchServiceName).map((Func1)new Func1<ServiceResponse<List<QueryKeyInner>>, List<QueryKeyInner>>(){

            public List<QueryKeyInner> call(ServiceResponse<List<QueryKeyInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<QueryKeyInner>>> listBySearchServiceWithServiceResponseAsync(String resourceGroupName, String searchServiceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (searchServiceName == null) {
            throw new IllegalArgumentException("Parameter searchServiceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object searchManagementRequestOptions = null;
        UUID clientRequestId = null;
        return this.service.listBySearchService(resourceGroupName, searchServiceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), clientRequestId, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<QueryKeyInner>>>>(){

            public Observable<ServiceResponse<List<QueryKeyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = QueryKeysInner.this.listBySearchServiceDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public List<QueryKeyInner> listBySearchService(String resourceGroupName, String searchServiceName, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        return (List)((ServiceResponse)this.listBySearchServiceWithServiceResponseAsync(resourceGroupName, searchServiceName, searchManagementRequestOptions).toBlocking().single()).body();
    }

    public ServiceFuture<List<QueryKeyInner>> listBySearchServiceAsync(String resourceGroupName, String searchServiceName, SearchManagementRequestOptionsInner searchManagementRequestOptions, ServiceCallback<List<QueryKeyInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listBySearchServiceWithServiceResponseAsync(resourceGroupName, searchServiceName, searchManagementRequestOptions), serviceCallback);
    }

    public Observable<List<QueryKeyInner>> listBySearchServiceAsync(String resourceGroupName, String searchServiceName, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        return this.listBySearchServiceWithServiceResponseAsync(resourceGroupName, searchServiceName, searchManagementRequestOptions).map((Func1)new Func1<ServiceResponse<List<QueryKeyInner>>, List<QueryKeyInner>>(){

            public List<QueryKeyInner> call(ServiceResponse<List<QueryKeyInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<QueryKeyInner>>> listBySearchServiceWithServiceResponseAsync(String resourceGroupName, String searchServiceName, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (searchServiceName == null) {
            throw new IllegalArgumentException("Parameter searchServiceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)searchManagementRequestOptions);
        UUID clientRequestId = null;
        if (searchManagementRequestOptions != null) {
            clientRequestId = searchManagementRequestOptions.clientRequestId();
        }
        return this.service.listBySearchService(resourceGroupName, searchServiceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), clientRequestId, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<QueryKeyInner>>>>(){

            public Observable<ServiceResponse<List<QueryKeyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = QueryKeysInner.this.listBySearchServiceDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<QueryKeyInner>> listBySearchServiceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<QueryKeyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String searchServiceName, String key) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, searchServiceName, key).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String searchServiceName, String key, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, searchServiceName, key), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String searchServiceName, String key) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, searchServiceName, key).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String searchServiceName, String key) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (searchServiceName == null) {
            throw new IllegalArgumentException("Parameter searchServiceName is required and cannot be null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("Parameter key is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object searchManagementRequestOptions = null;
        UUID clientRequestId = null;
        return this.service.delete(resourceGroupName, searchServiceName, key, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), clientRequestId, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = QueryKeysInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public void delete(String resourceGroupName, String searchServiceName, String key, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, searchServiceName, key, searchManagementRequestOptions).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String searchServiceName, String key, SearchManagementRequestOptionsInner searchManagementRequestOptions, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, searchServiceName, key, searchManagementRequestOptions), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String searchServiceName, String key, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, searchServiceName, key, searchManagementRequestOptions).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String searchServiceName, String key, SearchManagementRequestOptionsInner searchManagementRequestOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (searchServiceName == null) {
            throw new IllegalArgumentException("Parameter searchServiceName is required and cannot be null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("Parameter key is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)searchManagementRequestOptions);
        UUID clientRequestId = null;
        if (searchManagementRequestOptions != null) {
            clientRequestId = searchManagementRequestOptions.clientRequestId();
        }
        return this.service.delete(resourceGroupName, searchServiceName, key, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), clientRequestId, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = QueryKeysInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface QueryKeysService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.search.QueryKeys create"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/createQueryKey/{name}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="searchServiceName") String var2, @Path(value="name") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="x-ms-client-request-id") UUID var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.search.QueryKeys listBySearchService"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/listQueryKeys")
        public Observable<Response<ResponseBody>> listBySearchService(@Path(value="resourceGroupName") String var1, @Path(value="searchServiceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-client-request-id") UUID var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.search.QueryKeys delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/deleteQueryKey/{key}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="searchServiceName") String var2, @Path(value="key") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="x-ms-client-request-id") UUID var7, @Header(value="User-Agent") String var8);
    }
}

