/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.monitor.ErrorResponseException;
import com.microsoft.azure.management.monitor.implementation.MetricNamespaceInner;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.azure.management.monitor.implementation.PageImpl1;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class MetricNamespacesInner {
    private MetricNamespacesService service;
    private MonitorManagementClientImpl client;

    public MetricNamespacesInner(Retrofit retrofit, MonitorManagementClientImpl client) {
        this.service = (MetricNamespacesService)retrofit.create(MetricNamespacesService.class);
        this.client = client;
    }

    public List<MetricNamespaceInner> list(String resourceUri) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(resourceUri).toBlocking().single()).body();
    }

    public ServiceFuture<List<MetricNamespaceInner>> listAsync(String resourceUri, ServiceCallback<List<MetricNamespaceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceUri), serviceCallback);
    }

    public Observable<List<MetricNamespaceInner>> listAsync(String resourceUri) {
        return this.listWithServiceResponseAsync(resourceUri).map((Func1)new Func1<ServiceResponse<List<MetricNamespaceInner>>, List<MetricNamespaceInner>>(){

            public List<MetricNamespaceInner> call(ServiceResponse<List<MetricNamespaceInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<MetricNamespaceInner>>> listWithServiceResponseAsync(String resourceUri) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        String apiVersion = "2017-12-01-preview";
        String startTime = null;
        return this.service.list(resourceUri, "2017-12-01-preview", startTime, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MetricNamespaceInner>>>>(){

            public Observable<ServiceResponse<List<MetricNamespaceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = MetricNamespacesInner.this.listDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public List<MetricNamespaceInner> list(String resourceUri, String startTime) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(resourceUri, startTime).toBlocking().single()).body();
    }

    public ServiceFuture<List<MetricNamespaceInner>> listAsync(String resourceUri, String startTime, ServiceCallback<List<MetricNamespaceInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceUri, startTime), serviceCallback);
    }

    public Observable<List<MetricNamespaceInner>> listAsync(String resourceUri, String startTime) {
        return this.listWithServiceResponseAsync(resourceUri, startTime).map((Func1)new Func1<ServiceResponse<List<MetricNamespaceInner>>, List<MetricNamespaceInner>>(){

            public List<MetricNamespaceInner> call(ServiceResponse<List<MetricNamespaceInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<MetricNamespaceInner>>> listWithServiceResponseAsync(String resourceUri, String startTime) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        String apiVersion = "2017-12-01-preview";
        return this.service.list(resourceUri, "2017-12-01-preview", startTime, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MetricNamespaceInner>>>>(){

            public Observable<ServiceResponse<List<MetricNamespaceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = MetricNamespacesInner.this.listDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<MetricNamespaceInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<MetricNamespaceInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface MetricNamespacesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.MetricNamespaces list"})
        @GET(value="{resourceUri}/providers/microsoft.insights/metricNamespaces")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceUri", encoded=true) String var1, @Query(value="api-version") String var2, @Query(value="startTime") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);
    }
}

