/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.microsoft.azure.management.monitor.MetricAlertRuleTimeAggregation;
import com.microsoft.azure.management.monitor.MetricDimension;
import com.microsoft.azure.management.monitor.MultiMetricCriteria;
import com.microsoft.azure.management.monitor.implementation.MetricAlertImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.WrapperImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeMap;

class MetricAlertConditionBaseImpl<InnerT extends MultiMetricCriteria, SubclassT extends MetricAlertConditionBaseImpl<InnerT, SubclassT>>
extends WrapperImpl<InnerT> {
    protected final MetricAlertImpl parent;
    protected final TreeMap<String, MetricDimension> dimensions;

    protected MetricAlertConditionBaseImpl(String name, InnerT innerObject, MetricAlertImpl parent) {
        super(innerObject);
        ((MultiMetricCriteria)this.inner()).withName(name);
        this.parent = parent;
        this.dimensions = new TreeMap();
        if (((MultiMetricCriteria)this.inner()).dimensions() != null) {
            for (MetricDimension md : ((MultiMetricCriteria)this.inner()).dimensions()) {
                this.dimensions.put(md.name(), md);
            }
        }
    }

    public String name() {
        return ((MultiMetricCriteria)this.inner()).name();
    }

    public String metricName() {
        return ((MultiMetricCriteria)this.inner()).metricName();
    }

    public String metricNamespace() {
        return ((MultiMetricCriteria)this.inner()).metricNamespace();
    }

    public MetricAlertRuleTimeAggregation timeAggregation() {
        return MetricAlertRuleTimeAggregation.fromString(((MultiMetricCriteria)this.inner()).timeAggregation().toString());
    }

    public Collection<MetricDimension> dimensions() {
        return Collections.unmodifiableCollection(((MultiMetricCriteria)this.inner()).dimensions());
    }

    public MetricAlertImpl parent() {
        ((MultiMetricCriteria)this.inner()).withDimensions(new ArrayList<MetricDimension>(this.dimensions.values()));
        return this.parent;
    }

    public SubclassT withMetricName(String metricName) {
        ((MultiMetricCriteria)this.inner()).withMetricName(metricName);
        return (SubclassT)((Object)this);
    }

    public SubclassT withMetricName(String metricName, String metricNamespace) {
        ((MultiMetricCriteria)this.inner()).withMetricNamespace(metricNamespace);
        return this.withMetricName(metricName);
    }

    public SubclassT withDimension(String dimensionName, String ... values) {
        if (this.dimensions.containsKey(dimensionName)) {
            this.dimensions.remove(dimensionName);
        }
        MetricDimension md = new MetricDimension();
        md.withName(dimensionName);
        md.withOperator("Include");
        md.withValues(Arrays.asList(values));
        this.dimensions.put(dimensionName, md);
        return (SubclassT)((Object)this);
    }

    public SubclassT withoutDimension(String dimensionName) {
        if (this.dimensions.containsKey(dimensionName)) {
            this.dimensions.remove(dimensionName);
        }
        return (SubclassT)((Object)this);
    }
}

