/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.prompt;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.main.JsonValidator;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SchemaValidator {
    private Map<String, Map<String, Object>> schemaMap = new HashMap<String, Map<String, Object>>();
    private Map<String, JsonNode> schemas = new HashMap<String, JsonNode>();
    private final JsonValidator validator;
    private final ObjectMapper mapper = new ObjectMapper();

    public SchemaValidator() {
        this.validator = JsonSchemaFactory.byDefault().getValidator();
    }

    public void collectSingleProperty(String resource, String property, JsonNode schema) throws JsonProcessingException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)resource), (Object)"Parameter 'resource' should not be null or empty.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)property), (Object)"Parameter 'property' should not be null or empty.");
        Preconditions.checkArgument((!this.schemaMap.containsKey(SchemaValidator.combineToKey(resource, property)) ? 1 : 0) != 0, (Object)String.format("Duplicate property '%s'.", SchemaValidator.combineToKey(resource, property)));
        this.schemas.put(SchemaValidator.combineToKey(resource, property), schema);
        this.schemaMap.put(SchemaValidator.combineToKey(resource, property), (Map<String, Object>)this.mapper.treeToValue((TreeNode)schema, Map.class));
    }

    public Map<String, Object> getSchemaMap(String resource, String property) {
        this.checkExistSchema(resource, property);
        return this.schemaMap.get(SchemaValidator.combineToKey(resource, property));
    }

    public String validateSingleProperty(String resource, String property, String value) {
        this.checkExistSchema(resource, property);
        JsonNode schema = this.schemas.get(SchemaValidator.combineToKey(resource, property));
        String type = (String)this.schemaMap.get(SchemaValidator.combineToKey(resource, property)).get("type");
        try {
            ProcessingReport reports = this.validator.validate(schema, SchemaValidator.stringToJsonObject(type, value));
            return this.formatValidationResults(reports);
        }
        catch (ProcessingException | IllegalArgumentException e) {
            return e.getMessage();
        }
    }

    private void checkExistSchema(String resource, String property) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)resource), (Object)"Parameter 'resource' should not be null or empty.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)property), (Object)"Parameter 'property' should not be null or empty.");
        Preconditions.checkArgument((boolean)this.schemaMap.containsKey(SchemaValidator.combineToKey(resource, property)), (Object)String.format("Property '%s' cannot be found.", SchemaValidator.combineToKey(resource, property)));
    }

    private static String combineToKey(String resource, String property) {
        return resource + "::" + property;
    }

    private static JsonNode stringToJsonObject(String type, String value) {
        if ("string".equals(type)) {
            return TextNode.valueOf((String)value);
        }
        if ("integer".equals(type)) {
            try {
                return IntNode.valueOf((int)Integer.parseInt(value));
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(String.format("%s cannot be converted to an integer", value));
            }
        }
        if ("number".equals(type)) {
            try {
                return DoubleNode.valueOf((double)Double.parseDouble(value));
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(String.format("%s cannot be converted to an number", value));
            }
        }
        if ("boolean".equals(type)) {
            if ("true".equalsIgnoreCase(value)) {
                return BooleanNode.TRUE;
            }
            if ("false".equalsIgnoreCase(value)) {
                return BooleanNode.FALSE;
            }
            throw new IllegalArgumentException(String.format("%s cannot be converted to a boolean value.", value));
        }
        throw new IllegalArgumentException(String.format("Type '%s' is not supported in schema validation.", type));
    }

    private String formatValidationResults(ProcessingReport reports) {
        if (reports.isSuccess()) {
            return null;
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (ProcessingMessage pm : reports) {
            if (pm.asJson().has("keyword")) {
                errors.add(String.format("Keyword: %s, Detail: %s", pm.asJson().get("keyword"), pm.getMessage()));
                continue;
            }
            errors.add(pm.getMessage());
        }
        if (errors.size() == 1) {
            return (String)errors.get(0);
        }
        return String.format("The input violates the validation rules:\n %s", String.join((CharSequence)"\n", errors));
    }
}

