/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.credentials;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.credentials.MSIToken;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;

@Beta
public class MSICredentials
extends AzureTokenCredentials {
    private final String resource;
    private final int msiPort;
    private final AzureJacksonAdapter adapter;
    private String objectId;
    private String clientId;
    private String identityId;

    public MSICredentials() {
        this(AzureEnvironment.AZURE);
    }

    public MSICredentials(AzureEnvironment environment) {
        this(environment, 50342);
    }

    public MSICredentials(AzureEnvironment environment, int msiPort) {
        super(environment, null);
        this.resource = environment.resourceManagerEndpoint();
        this.msiPort = msiPort;
        this.adapter = new AzureJacksonAdapter();
    }

    @Beta
    public MSICredentials withObjectId(String objectId) {
        this.objectId = objectId;
        this.clientId = null;
        this.identityId = null;
        return this;
    }

    @Beta
    public MSICredentials withClientId(String clientId) {
        this.clientId = clientId;
        this.objectId = null;
        this.identityId = null;
        return this;
    }

    @Beta
    public MSICredentials withIdentityId(String identityId) {
        this.identityId = identityId;
        this.clientId = null;
        this.objectId = null;
        return this;
    }

    public String getToken(String resource) throws IOException {
        URL url = new URL(String.format("http://localhost:%d/oauth2/token", this.msiPort));
        String postData = String.format("resource=%s", this.resource);
        if (this.objectId != null) {
            postData = postData + String.format("&object_id=%s", this.objectId);
        } else if (this.clientId != null) {
            postData = postData + String.format("&client_id=%s", this.clientId);
        } else if (this.identityId != null) {
            postData = postData + String.format("&msi_res_id=%s", this.identityId);
        }
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            connection.setRequestProperty("Metadata", "true");
            connection.setRequestProperty("Content-Length", Integer.toString(postData.length()));
            connection.setDoOutput(true);
            connection.connect();
            OutputStreamWriter wr = new OutputStreamWriter(connection.getOutputStream());
            wr.write(postData);
            wr.flush();
            InputStream stream = connection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"), 100);
            String result = reader.readLine();
            MSIToken msiToken = (MSIToken)this.adapter.deserialize(result, MSIToken.class);
            String string = msiToken.accessToken();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

