/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.internal.correlation;

import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.web.dependencies.apachecommons.lang3.StringUtils;
import com.microsoft.applicationinsights.web.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.web.internal.correlation.AppProfileFetcher;
import com.microsoft.applicationinsights.web.internal.correlation.ApplicationIdResolver;
import com.microsoft.applicationinsights.web.internal.correlation.CdsProfileFetcher;
import com.microsoft.applicationinsights.web.internal.correlation.ProfileFetcherResult;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public enum InstrumentationKeyResolver {
    INSTANCE;

    private static final String CorrelationIdFormat = "cid-v1:%s";
    private volatile ApplicationIdResolver appIdResolver;
    private final ConcurrentMap<String, String> appIdCache = new ConcurrentHashMap<String, String>();

    private InstrumentationKeyResolver() {
        this.appIdResolver = new CdsProfileFetcher();
    }

    public void clearCache() {
        this.appIdCache.clear();
    }

    @Deprecated
    public void setProfileFetcher(AppProfileFetcher profileFetcher) {
    }

    void setAppIdResolver(ApplicationIdResolver appIdResolver) {
        this.appIdResolver = appIdResolver;
    }

    @Deprecated
    public String resolveInstrumentationKey(String instrumentationKey) {
        return this.resolveInstrumentationKey(instrumentationKey, TelemetryConfiguration.getActive());
    }

    public String resolveInstrumentationKey(String instrumentationKey, TelemetryConfiguration config) {
        if (StringUtils.isEmpty(instrumentationKey)) {
            throw new IllegalArgumentException("instrumentationKey must not be null or empty");
        }
        if (config == null) {
            throw new IllegalArgumentException("config must not be null or empty");
        }
        try {
            String appId = (String)this.appIdCache.get(instrumentationKey);
            if (appId != null) {
                return appId;
            }
            ProfileFetcherResult result = this.appIdResolver.fetchApplicationId(instrumentationKey, config);
            appId = this.processResult(result, instrumentationKey);
            if (appId != null) {
                this.appIdCache.putIfAbsent(instrumentationKey, appId);
            }
            return appId;
        }
        catch (Exception e) {
            if (InternalLogger.INSTANCE.isErrorEnabled()) {
                InternalLogger.INSTANCE.error("InstrumentationKeyResolver: failed to resolve instrumentation key: %s => Exception: %s", config.getInstrumentationKey(), ExceptionUtils.getStackTrace(e));
            }
            return null;
        }
    }

    private String processResult(ProfileFetcherResult result, String instrumentationKey) {
        String appId = null;
        switch (result.getStatus()) {
            case PENDING: {
                InternalLogger.INSTANCE.trace("InstrumentationKeyResolver - pending resolution of instrumentation key: %s", instrumentationKey);
                break;
            }
            case FAILED: {
                InternalLogger.INSTANCE.error("InstrumentationKeyResolver - failed to resolve instrumentation key: %s", instrumentationKey);
                break;
            }
            case COMPLETE: {
                InternalLogger.INSTANCE.trace("InstrumentationKeyResolver - successfully resolved instrumentation key: %s", instrumentationKey);
                appId = String.format(CorrelationIdFormat, result.getAppId());
                break;
            }
            default: {
                InternalLogger.INSTANCE.error("InstrumentationKeyResolver - unexpected status. Instrumentation key: %s", instrumentationKey);
            }
        }
        return appId;
    }
}

