/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.dependencies.http.impl.nio.client;

import com.microsoft.applicationinsights.web.dependencies.apachecommons.logging.Log;
import com.microsoft.applicationinsights.web.dependencies.http.ConnectionReuseStrategy;
import com.microsoft.applicationinsights.web.dependencies.http.HttpException;
import com.microsoft.applicationinsights.web.dependencies.http.HttpHost;
import com.microsoft.applicationinsights.web.dependencies.http.HttpRequest;
import com.microsoft.applicationinsights.web.dependencies.http.HttpResponse;
import com.microsoft.applicationinsights.web.dependencies.http.client.methods.HttpExecutionAware;
import com.microsoft.applicationinsights.web.dependencies.http.client.protocol.HttpClientContext;
import com.microsoft.applicationinsights.web.dependencies.http.concurrent.BasicFuture;
import com.microsoft.applicationinsights.web.dependencies.http.conn.ConnectionKeepAliveStrategy;
import com.microsoft.applicationinsights.web.dependencies.http.impl.nio.client.AbstractClientExchangeHandler;
import com.microsoft.applicationinsights.web.dependencies.http.impl.nio.client.InternalClientExec;
import com.microsoft.applicationinsights.web.dependencies.http.impl.nio.client.InternalState;
import com.microsoft.applicationinsights.web.dependencies.http.nio.ContentDecoder;
import com.microsoft.applicationinsights.web.dependencies.http.nio.ContentEncoder;
import com.microsoft.applicationinsights.web.dependencies.http.nio.IOControl;
import com.microsoft.applicationinsights.web.dependencies.http.nio.NHttpClientConnection;
import com.microsoft.applicationinsights.web.dependencies.http.nio.conn.NHttpClientConnectionManager;
import com.microsoft.applicationinsights.web.dependencies.http.nio.protocol.HttpAsyncRequestProducer;
import com.microsoft.applicationinsights.web.dependencies.http.nio.protocol.HttpAsyncResponseConsumer;
import java.io.IOException;

class DefaultClientExchangeHandlerImpl<T>
extends AbstractClientExchangeHandler {
    private final HttpAsyncRequestProducer requestProducer;
    private final HttpAsyncResponseConsumer<T> responseConsumer;
    private final BasicFuture<T> resultFuture;
    private final InternalClientExec exec;
    private final InternalState state;

    public DefaultClientExchangeHandlerImpl(Log log, HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpClientContext localContext, BasicFuture<T> resultFuture, NHttpClientConnectionManager connmgr, ConnectionReuseStrategy connReuseStrategy, ConnectionKeepAliveStrategy keepaliveStrategy, InternalClientExec exec) {
        super(log, localContext, connmgr, connReuseStrategy, keepaliveStrategy);
        this.requestProducer = requestProducer;
        this.responseConsumer = responseConsumer;
        this.resultFuture = resultFuture;
        this.exec = exec;
        this.state = new InternalState(this.getId(), requestProducer, responseConsumer, localContext);
    }

    @Override
    void releaseResources() {
        try {
            this.requestProducer.close();
        }
        catch (IOException ex) {
            this.log.debug("I/O error closing request producer", ex);
        }
        try {
            this.responseConsumer.close();
        }
        catch (IOException ex) {
            this.log.debug("I/O error closing response consumer", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executionFailed(Exception ex) {
        try {
            this.requestProducer.failed(ex);
            this.responseConsumer.failed(ex);
        }
        finally {
            this.resultFuture.failed(ex);
        }
    }

    @Override
    boolean executionCancelled() {
        boolean cancelled = this.responseConsumer.cancel();
        T result = this.responseConsumer.getResult();
        Exception ex = this.responseConsumer.getException();
        if (ex != null) {
            this.resultFuture.failed(ex);
        } else if (result != null) {
            this.resultFuture.completed(result);
        } else {
            this.resultFuture.cancel();
        }
        return cancelled;
    }

    public void start() throws HttpException, IOException {
        HttpHost target = this.requestProducer.getTarget();
        HttpRequest original = this.requestProducer.generateRequest();
        if (original instanceof HttpExecutionAware) {
            ((HttpExecutionAware)((Object)original)).setCancellable(this);
        }
        this.exec.prepare(target, original, this.state, this);
        this.requestConnection();
    }

    @Override
    public HttpRequest generateRequest() throws IOException, HttpException {
        return this.exec.generateRequest(this.state, this);
    }

    @Override
    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        this.exec.produceContent(this.state, encoder, ioctrl);
    }

    @Override
    public void requestCompleted() {
        this.exec.requestCompleted(this.state, this);
    }

    @Override
    public void responseReceived(HttpResponse response) throws IOException, HttpException {
        this.exec.responseReceived(response, this.state, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consumeContent(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        this.exec.consumeContent(this.state, decoder, ioctrl);
        if (!decoder.isCompleted() && this.responseConsumer.isDone()) {
            this.markConnectionNonReusable();
            try {
                this.markCompleted();
                this.releaseConnection();
                this.resultFuture.cancel();
            }
            finally {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void responseCompleted() throws IOException, HttpException {
        this.exec.responseCompleted(this.state, this);
        if (this.state.getFinalResponse() != null || this.resultFuture.isDone()) {
            try {
                this.markCompleted();
                this.releaseConnection();
                T result = this.responseConsumer.getResult();
                Exception ex = this.responseConsumer.getException();
                if (ex == null) {
                    this.resultFuture.completed(result);
                }
                this.resultFuture.failed(ex);
            }
            finally {
                this.close();
            }
        } else {
            NHttpClientConnection localConn = this.getConnection();
            if (localConn != null && !localConn.isOpen()) {
                this.releaseConnection();
                localConn = null;
            }
            if (localConn != null) {
                localConn.requestOutput();
            } else {
                this.requestConnection();
            }
        }
    }

    @Override
    public void inputTerminated() {
        if (!this.isCompleted()) {
            this.requestConnection();
        } else {
            this.close();
        }
    }

    public void abortConnection() {
        this.discardConnection();
    }
}

