/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.microsoft.applicationinsights.extensibility.context.CloudContext;
import com.microsoft.applicationinsights.extensibility.context.ComponentContext;
import com.microsoft.applicationinsights.extensibility.context.DeviceContext;
import com.microsoft.applicationinsights.extensibility.context.LocationContext;
import com.microsoft.applicationinsights.extensibility.context.OperationContext;
import com.microsoft.applicationinsights.extensibility.context.SessionContext;
import com.microsoft.applicationinsights.extensibility.context.UserContext;
import com.microsoft.applicationinsights.telemetry.ContextTagsMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class TelemetryContext {
    private final ConcurrentMap<String, String> properties;
    private final ContextTagsMap tags;
    private String connectionString;
    private ComponentContext component;
    private DeviceContext device;
    private SessionContext session;
    private UserContext user;
    private OperationContext operation;
    private LocationContext location;
    private CloudContext cloud;

    public TelemetryContext() {
        this(new ConcurrentHashMap<String, String>(), new ContextTagsMap());
    }

    TelemetryContext(ConcurrentMap<String, String> properties, ContextTagsMap tags) {
        if (properties == null) {
            throw new IllegalArgumentException("properties cannot be null");
        }
        if (tags == null) {
            throw new IllegalArgumentException("tags cannot be null");
        }
        this.properties = properties;
        this.tags = tags;
    }

    public ComponentContext getComponent() {
        if (this.component == null) {
            this.component = new ComponentContext(this.tags);
        }
        return this.component;
    }

    public DeviceContext getDevice() {
        if (this.device == null) {
            this.device = new DeviceContext(this.tags);
        }
        return this.device;
    }

    public SessionContext getSession() {
        if (this.session == null) {
            this.session = new SessionContext(this.tags);
        }
        return this.session;
    }

    public UserContext getUser() {
        if (this.user == null) {
            this.user = new UserContext(this.tags);
        }
        return this.user;
    }

    public OperationContext getOperation() {
        if (this.operation == null) {
            this.operation = new OperationContext(this.tags);
        }
        return this.operation;
    }

    public LocationContext getLocation() {
        if (this.location == null) {
            this.location = new LocationContext(this.tags);
        }
        return this.location;
    }

    public CloudContext getCloud() {
        if (this.cloud == null) {
            this.cloud = new CloudContext(this.tags);
        }
        return this.cloud;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public ConcurrentMap<String, String> getProperties() {
        return this.properties;
    }

    public ConcurrentMap<String, String> getTags() {
        return this.tags;
    }
}

