/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.microsoft.applicationinsights.internal.schemav2.ExceptionData;
import com.microsoft.applicationinsights.telemetry.BaseTelemetry;
import com.microsoft.applicationinsights.telemetry.SeverityLevel;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public final class ExceptionTelemetry
extends BaseTelemetry {
    private final ExceptionData data = new ExceptionData();
    private Throwable throwable;

    public ExceptionTelemetry() {
        this.initialize(this.data.getProperties());
    }

    public ExceptionTelemetry(Throwable throwable, int stackSize) {
        this();
        this.throwable = throwable;
    }

    public ExceptionTelemetry(Throwable throwable) {
        this(throwable, Integer.MAX_VALUE);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setException(Throwable throwable) {
        this.setException(throwable, Integer.MAX_VALUE);
    }

    public void setException(Throwable throwable, int stackSize) {
        this.throwable = throwable;
    }

    public void setSeverityLevel(SeverityLevel severityLevel) {
        this.data.setSeverityLevel(severityLevel == null ? null : com.microsoft.applicationinsights.internal.schemav2.SeverityLevel.values()[severityLevel.getValue()]);
    }

    @Nullable
    public SeverityLevel getSeverityLevel() {
        return this.data.getSeverityLevel() == null ? null : SeverityLevel.values()[this.data.getSeverityLevel().getValue()];
    }

    public ConcurrentMap<String, Double> getMetrics() {
        return this.data.getMeasurements();
    }

    @Override
    protected ExceptionData getData() {
        return this.data;
    }
}

