/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights;

import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import com.microsoft.applicationinsights.internal.util.MapUtil;
import com.microsoft.applicationinsights.telemetry.AvailabilityTelemetry;
import com.microsoft.applicationinsights.telemetry.Duration;
import com.microsoft.applicationinsights.telemetry.EventTelemetry;
import com.microsoft.applicationinsights.telemetry.ExceptionTelemetry;
import com.microsoft.applicationinsights.telemetry.MetricTelemetry;
import com.microsoft.applicationinsights.telemetry.PageViewTelemetry;
import com.microsoft.applicationinsights.telemetry.RemoteDependencyTelemetry;
import com.microsoft.applicationinsights.telemetry.RequestTelemetry;
import com.microsoft.applicationinsights.telemetry.SeverityLevel;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import com.microsoft.applicationinsights.telemetry.TelemetryContext;
import com.microsoft.applicationinsights.telemetry.TraceTelemetry;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;

public class TelemetryClient {
    private final TelemetryContext context = new TelemetryContext();

    public TelemetryContext getContext() {
        return this.context;
    }

    public void trackEvent(String name, @Nullable Map<String, String> properties, @Nullable Map<String, Double> metrics) {
        if (name == null || name.isEmpty()) {
            name = "";
        }
        EventTelemetry telemetry = new EventTelemetry(name);
        MapUtil.copy(properties, telemetry.getContext().getProperties());
        MapUtil.copy(metrics, telemetry.getMetrics());
        this.trackEvent(telemetry);
    }

    public void trackEvent(String name) {
        this.trackEvent(name, null, null);
    }

    public void trackEvent(EventTelemetry telemetry) {
        this.track(telemetry);
    }

    public void trackTrace(String message, @Nullable SeverityLevel severityLevel, @Nullable Map<String, String> properties) {
        if (LocalStringsUtils.isNullOrEmpty(message)) {
            message = "";
        }
        TraceTelemetry telemetry = new TraceTelemetry(message, severityLevel);
        MapUtil.copy(properties, telemetry.getContext().getProperties());
        this.trackTrace(telemetry);
    }

    public void trackTrace(String message) {
        this.trackTrace(message, null, null);
    }

    public void trackTrace(String message, SeverityLevel severityLevel) {
        this.trackTrace(message, severityLevel, null);
    }

    public void trackTrace(TraceTelemetry telemetry) {
        this.track(telemetry);
    }

    public void trackMetric(String name, double value, @Nullable Integer sampleCount, @Nullable Double min, @Nullable Double max, @Nullable Double stdDev, @Nullable Map<String, String> properties) {
        MetricTelemetry telemetry = new MetricTelemetry(name, value);
        telemetry.setCount(sampleCount);
        telemetry.setMin(min);
        telemetry.setMax(max);
        telemetry.setStandardDeviation(stdDev);
        MapUtil.copy(properties, telemetry.getProperties());
        this.trackMetric(telemetry);
    }

    public void trackMetric(String name, double value) {
        this.trackMetric(name, value, null, null, null, null, null);
    }

    public void trackMetric(MetricTelemetry telemetry) {
        this.track(telemetry);
    }

    public void trackException(Exception exception, @Nullable Map<String, String> properties, @Nullable Map<String, Double> metrics) {
        ExceptionTelemetry telemetry = new ExceptionTelemetry(exception);
        MapUtil.copy(properties, telemetry.getContext().getProperties());
        MapUtil.copy(metrics, telemetry.getMetrics());
        this.trackException(telemetry);
    }

    public void trackException(Exception exception) {
        this.trackException(exception, null, null);
    }

    public void trackException(ExceptionTelemetry telemetry) {
        this.track(telemetry);
    }

    public void trackHttpRequest(String name, Date timestamp, long duration, String responseCode, boolean success) {
        this.trackRequest(new RequestTelemetry(name, timestamp, duration, responseCode, success));
    }

    public void trackRequest(RequestTelemetry request) {
        this.track(request);
    }

    public void trackDependency(String dependencyName, String commandName, Duration duration, boolean success) {
        this.trackDependency(new RemoteDependencyTelemetry(dependencyName, commandName, duration, success));
    }

    public void trackDependency(RemoteDependencyTelemetry telemetry) {
        if (telemetry == null) {
            telemetry = new RemoteDependencyTelemetry("");
        }
        this.track(telemetry);
    }

    public void trackPageView(String name) {
        if (name == null) {
            name = "";
        }
        this.trackPageView(new PageViewTelemetry(name));
    }

    public void trackPageView(PageViewTelemetry telemetry) {
        this.track(telemetry);
    }

    public void trackAvailability(AvailabilityTelemetry telemetry) {
        this.track(telemetry);
    }

    public void flush() {
    }

    public void track(Telemetry telemetry) {
    }
}

