/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.security.util;

import com.mendmix.common.constants.PermissionLevel;
import com.mendmix.common.model.ApiModel;
import com.mendmix.security.SecurityDecisionProvider;
import com.mendmix.security.SecurityDelegating;
import com.mendmix.security.model.ApiPermission;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiPermssionHelper {
    private static Logger logger = LoggerFactory.getLogger((String)"com.mendmix.security");
    private static ApiPermission defaultApiOnNotMatch = new ApiPermission(null, null, PermissionLevel.LoginRequired);
    private static Map<String, ApiPermission> apiPermissions = new HashMap<String, ApiPermission>();
    private static Map<Pattern, ApiPermission> wildcardUris = new HashMap<Pattern, ApiPermission>();
    public static final String WILDCARD_START = "{";
    private static final String PATH_VARIABLE_REGEX = "\\{[^/]+?\\}";
    private static final String LEAST_ONE_REGEX = ".+";

    private static void init() {
        String permissionKey;
        SecurityDecisionProvider decisionProvider = SecurityDelegating.decisionProvider();
        List<ApiPermission> permissions = decisionProvider.getAllApiPermissions();
        for (ApiPermission apiPermission : permissions) {
            if (apiPermission.getPermissionLevel() == PermissionLevel.LoginRequired) continue;
            permissionKey = ApiPermssionHelper.buildPermissionKey(apiPermission.getMethod(), apiPermission.getUri());
            apiPermission.setPermissionKey(permissionKey);
            apiPermissions.put(permissionKey, apiPermission);
            if (!permissionKey.contains(WILDCARD_START)) continue;
            Pattern pattern = Pattern.compile(ApiPermssionHelper.pathVariableToPattern(permissionKey));
            wildcardUris.put(pattern, apiPermission);
        }
        List<ApiModel> anonymousUris = decisionProvider.anonymousUris();
        for (ApiModel api : anonymousUris) {
            permissionKey = ApiPermssionHelper.buildPermissionKey(api.getMethod(), api.getUri());
            ApiPermission apiPermission = new ApiPermission(api.getMethod(), api.getUri(), PermissionLevel.Anonymous);
            if (api.getUri().contains("*")) {
                Pattern pattern = Pattern.compile(ApiPermssionHelper.pathVariableToPattern(permissionKey.replaceAll("\\*+", LEAST_ONE_REGEX)));
                wildcardUris.put(pattern, apiPermission);
                continue;
            }
            apiPermissions.put(permissionKey, apiPermission);
        }
        if (apiPermissions.isEmpty()) {
            apiPermissions.put("_", defaultApiOnNotMatch);
        }
    }

    public static void reload() {
        apiPermissions.clear();
        ApiPermssionHelper.init();
        logger.info("MENDMIX-TRACE-LOGGGING-->> reload apiPermissions:{}", (Object)apiPermissions.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApiPermission matchPermissionObject(String method, String uri) {
        String permissionKey;
        ApiPermission api;
        if (apiPermissions.isEmpty()) {
            Map<String, ApiPermission> map = apiPermissions;
            synchronized (map) {
                if (apiPermissions.isEmpty()) {
                    ApiPermssionHelper.init();
                    logger.info("MENDMIX-TRACE-LOGGGING-->> reload apiPermissions:{}", (Object)apiPermissions.size());
                }
            }
        }
        if ((api = apiPermissions.get(permissionKey = ApiPermssionHelper.buildPermissionKey(method, uri))) != null) {
            return api;
        }
        for (Pattern pattern : wildcardUris.keySet()) {
            if (!pattern.matcher(permissionKey).matches()) continue;
            return wildcardUris.get(pattern);
        }
        return defaultApiOnNotMatch;
    }

    public static String buildPermissionKey(String method, String uri) {
        return method.toUpperCase() + "_" + uri;
    }

    public static String pathVariableToPattern(String uri) {
        return uri.replaceAll(PATH_VARIABLE_REGEX, LEAST_ONE_REGEX);
    }
}

