/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.security.context;

import com.mendmix.common.CurrentRuntimeContext;
import com.mendmix.common.GlobalConstants;
import com.mendmix.common.ThreadLocalContext;
import com.mendmix.security.RequestContextAdapter;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletRequestContextAdapter
implements RequestContextAdapter {
    public static void init(HttpServletRequest request, HttpServletResponse response) {
        ThreadLocalContext.unset();
        ThreadLocalContext.set((String)"_ctx_request_key", (Object)request);
        ThreadLocalContext.set((String)"_ctx_response_key", (Object)response);
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            CurrentRuntimeContext.addContextHeader((String)headerName, (String)request.getHeader(headerName));
        }
    }

    @Override
    public String getHeader(String headerName) {
        HttpServletRequest request = (HttpServletRequest)ThreadLocalContext.get((String)"_ctx_request_key");
        return request.getHeader(headerName);
    }

    @Override
    public String getCookie(String cookieName) {
        Cookie[] cookies;
        HttpServletRequest request = (HttpServletRequest)ThreadLocalContext.get((String)"_ctx_request_key");
        for (Cookie cookie : cookies = request.getCookies()) {
            if (!cookie.getName().equalsIgnoreCase(cookieName)) continue;
            return cookie.getValue();
        }
        return null;
    }

    @Override
    public void addCookie(String domain, String cookieName, String cookieValue, int expire) {
        Cookie cookie = new Cookie(cookieName, cookieValue);
        cookie.setDomain(domain);
        cookie.setPath(GlobalConstants.PATH_SEPARATOR);
        cookie.setHttpOnly(true);
        if (expire >= 0) {
            cookie.setMaxAge(expire);
        }
        HttpServletResponse response = (HttpServletResponse)ThreadLocalContext.get((String)"_ctx_response_key");
        response.addCookie(cookie);
    }
}

