/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.security.context;

import com.mendmix.common.CurrentRuntimeContext;
import com.mendmix.common.ThreadLocalContext;
import com.mendmix.security.RequestContextAdapter;
import java.util.Map;
import org.springframework.http.HttpCookie;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ReactiveRequestContextAdapter
implements RequestContextAdapter {
    public static void init(ServerHttpRequest request) {
        ThreadLocalContext.set((String)"_ctx_request_key", (Object)request);
        CurrentRuntimeContext.addContextHeaders((Map)request.getHeaders().toSingleValueMap());
    }

    @Override
    public String getHeader(String headerName) {
        ServerHttpRequest request = (ServerHttpRequest)ThreadLocalContext.get((String)"_ctx_request_key");
        return request.getHeaders().getFirst(headerName);
    }

    @Override
    public String getCookie(String cookieName) {
        ServerHttpRequest request = (ServerHttpRequest)ThreadLocalContext.get((String)"_ctx_request_key");
        HttpCookie cookie = (HttpCookie)request.getCookies().getFirst((Object)cookieName);
        return cookie == null ? null : cookie.getValue();
    }

    @Override
    public void addCookie(String domain, String cookieName, String cookieValue, int expire) {
    }

    private static Mono<ServerHttpRequest> getServerHttpRequest() {
        return Mono.deferContextual(Mono::just).map(contextView -> ((ServerWebExchange)contextView.get(ServerWebExchange.class)).getRequest());
    }
}

