/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.security.connect.oauth;

import com.mendmix.common.model.AuthUser;
import com.mendmix.common.util.ResourceUtils;
import com.mendmix.security.SecurityDelegating;
import com.mendmix.security.connect.oauth.CallbackResult;
import com.mendmix.security.connect.oauth.OauthClient;
import com.mendmix.security.connect.oauth.OauthNextHandler;
import com.mendmix.security.connect.oauth.OauthNextResult;
import com.mendmix.security.model.UserSession;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.reactive.result.view.Rendering;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
public class OauthEndpointController
implements InitializingBean {
    private static Logger logger = LoggerFactory.getLogger((String)"com.mendmix.security");
    private Map<String, OauthClient> oauth2Configs = new HashMap<String, OauthClient>();
    @Autowired
    private OauthNextHandler<? extends AuthUser> oauthNextHandler;

    @GetMapping(value={"/oauth2/{type}/redirect"})
    public Object oauth2Redirect(ServerHttpRequest request, @PathVariable(value="type") String type) {
        OauthClient client = this.oauth2Configs.get(type);
        return Rendering.redirectTo((String)client.onceAuthorizeUrl(request)).build();
    }

    @GetMapping(value={"/oauth2/{type}/callback"})
    public Rendering oauth2Endpoint(ServerHttpRequest request, @PathVariable(value="type") String type) {
        String redirectUrl = null;
        try {
            OauthClient client = this.oauth2Configs.get(type);
            CallbackResult callbackResult = client.validateRedirectRequest(request);
            Map<String, Object> openUserInfo = client.exchange(request, callbackResult);
            OauthNextResult<? extends AuthUser> oauthNextResult = this.oauthNextHandler.handle(type, openUserInfo);
            redirectUrl = StringUtils.defaultString((String)oauthNextResult.getRedirectUrl(), (String)callbackResult.getOrginUrl());
            if (oauthNextResult.getUser() != null) {
                UserSession session = SecurityDelegating.updateSession(oauthNextResult.getUser(), true);
                redirectUrl = redirectUrl + (redirectUrl.contains("?") ? "&" : "?") + "sessionId" + session.getSessionId();
            }
        }
        catch (Exception e) {
            logger.error("oauth2callback_error", (Throwable)e);
            if (redirectUrl == null) {
                request.getHeaders().getFirst("Referer");
            }
            redirectUrl = UriComponentsBuilder.fromHttpUrl(redirectUrl).replaceQuery("error=" + e.getMessage()).build().encode().toUriString();
        }
        return Rendering.redirectTo((String)redirectUrl).build();
    }

    public void afterPropertiesSet() throws Exception {
        Set types = ResourceUtils.getMappingValues((String)"mendmix.security.oauth").keySet();
        for (String type : types) {
            OauthClient client = new OauthClient();
            client.setType(type);
            client.setClientId(ResourceUtils.getAndValidateProperty((String)String.format("mendmix.security.oauth[%s].clientId", type)));
            client.setClientSecret(ResourceUtils.getAndValidateProperty((String)String.format("mendmix.security.oauth[%s].clientSecret", type)));
            client.setAuthorizeUrl(ResourceUtils.getAndValidateProperty((String)String.format("mendmix.security.oauth[%s].authorizeUrl", type)));
            client.setAccessTokenUrl(ResourceUtils.getAndValidateProperty((String)String.format("mendmix.security.oauth[%s].accessTokenUrl", type)));
            client.setUserInfoUrl(ResourceUtils.getAndValidateProperty((String)String.format("mendmix.security.oauth[%s].userInfoUrl", type)));
            client.afterPropertiesSet();
            this.oauth2Configs.put(type, client);
        }
    }
}

