/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.security.connect.oauth;

import com.mendmix.common.MendmixBaseException;
import com.mendmix.common.http.HttpResponseEntity;
import com.mendmix.common.util.HttpUtils;
import com.mendmix.common.util.JsonUtils;
import com.mendmix.common.util.ResourceUtils;
import com.mendmix.common.util.TokenGenerator;
import com.mendmix.security.SecurityDelegating;
import com.mendmix.security.connect.oauth.CallbackResult;
import com.mendmix.security.connect.oauth.OauthParameter;
import com.mendmix.security.connect.oauth.OauthStandardField;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;

public class OauthClient {
    private static Map<String, String> aliasMapping = new HashMap<String, String>();
    private String type;
    private String clientId;
    private String clientSecret;
    private String authorizeUrl;
    private String accessTokenUrl;
    private String userInfoUrl;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getAuthorizeUrl() {
        return this.authorizeUrl;
    }

    public void setAuthorizeUrl(String authorizeUrl) {
        this.authorizeUrl = authorizeUrl;
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public void setAccessTokenUrl(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    public String getUserInfoUrl() {
        return this.userInfoUrl;
    }

    public void setUserInfoUrl(String userInfoUrl) {
        this.userInfoUrl = userInfoUrl;
    }

    public String onceAuthorizeUrl(ServerHttpRequest request) {
        String url = this.authorizeUrl;
        String redirectUri = request.getURI().toString().replace("/redirect", "/callback");
        url = url.replace(OauthParameter.redirectUri.getExpression(), redirectUri);
        String state = TokenGenerator.generate((String[])new String[0]);
        url = url.replace(OauthParameter.state.getExpression(), state);
        String referer = request.getHeaders().getFirst("Referer");
        SecurityDelegating.setTemporaryState(state, referer + "|" + redirectUri);
        return url;
    }

    public String onceParameterValue(ServerHttpRequest request, OauthParameter parameter) {
        return (String)request.getQueryParams().getFirst((Object)parameter.name());
    }

    public CallbackResult validateRedirectRequest(ServerHttpRequest request) {
        String errorMsg = (String)request.getQueryParams().getFirst((Object)this.getOauthField(OauthStandardField.errMsg));
        if (errorMsg != null) {
            throw new MendmixBaseException(errorMsg);
        }
        String code = (String)request.getQueryParams().getFirst((Object)OauthParameter.code.name());
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new MendmixBaseException("Parameter[code] is required");
        }
        String state = (String)request.getQueryParams().getFirst((Object)OauthParameter.state.name());
        if (StringUtils.isBlank((CharSequence)state)) {
            throw new MendmixBaseException("Parameter[state] is required");
        }
        String stateValue = SecurityDelegating.getTemporaryState(state);
        if (stateValue == null) {
            throw new MendmixBaseException("Parameter[state] is invalid");
        }
        String[] values = StringUtils.split((String)stateValue, (String)"|");
        return new CallbackResult(code, values[0], values[1]);
    }

    public Map<String, Object> exchange(ServerHttpRequest request, CallbackResult callback) {
        String url = this.accessTokenUrl;
        url = url.replace(OauthParameter.code.getExpression(), callback.getCode()).replace(OauthParameter.redirectUri.getExpression(), callback.getRedirectUri());
        HttpResponseEntity responseEntity = HttpUtils.get((String)url);
        String accessToken = this.parseHttpResponse(responseEntity).get(this.getOauthField(OauthStandardField.access_token)).toString();
        url = this.userInfoUrl.replace(OauthParameter.access_token.getExpression(), accessToken);
        responseEntity = HttpUtils.get((String)url);
        return this.parseHttpResponse(responseEntity);
    }

    public void afterPropertiesSet() {
        this.authorizeUrl = this.authorizeUrl.replace(OauthParameter.clientId.getExpression(), this.clientId);
        this.accessTokenUrl = this.accessTokenUrl.replace(OauthParameter.clientId.getExpression(), this.clientId);
        this.accessTokenUrl = this.accessTokenUrl.replace(OauthParameter.clientSecret.getExpression(), this.clientSecret);
        this.userInfoUrl = this.userInfoUrl.replace(OauthParameter.clientId.getExpression(), this.clientId);
        this.userInfoUrl = this.userInfoUrl.replace(OauthParameter.clientSecret.getExpression(), this.clientSecret);
        String aliasProps = ResourceUtils.getProperty((String)String.format("mendmix.security.oauth[%s].aliasMapping", this.type));
        if (StringUtils.isNotBlank((CharSequence)aliasProps)) {
            String[] pairs;
            for (String pair : pairs = StringUtils.split((String)aliasProps, (String)",")) {
                String[] parts = StringUtils.split((String)pair, (String)"=");
                aliasMapping.put(parts[0], parts[1]);
            }
        }
    }

    private Map<String, Object> parseHttpResponse(HttpResponseEntity responseEntity) {
        String errorMsgField;
        if (!responseEntity.isSuccessed()) {
            throw new MendmixBaseException(responseEntity.getStatusCode(), responseEntity.getMessage());
        }
        Map map = JsonUtils.toHashMap((String)responseEntity.getBody());
        if (map.containsKey(errorMsgField = this.getOauthField(OauthStandardField.errMsg))) {
            String msg = map.get(errorMsgField).toString();
            throw new MendmixBaseException(msg);
        }
        return map;
    }

    private String getOauthField(OauthStandardField field) {
        if (aliasMapping.containsKey(field.name())) {
            return aliasMapping.get(field.name());
        }
        return field.name();
    }
}

