/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.security.cache;

import com.mendmix.cache.RedisTemplateGroups;
import com.mendmix.security.Cache;
import java.time.Duration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisCache
implements Cache {
    private static final String CACHE_GROUP_NAME = "mendmix.security";
    private StringRedisTemplate stringRedisTemplate = RedisTemplateGroups.getStringRedisTemplate((String)"mendmix.security");
    private RedisTemplate<String, Object> redisTemplate = RedisTemplateGroups.getRedisTemplate((String)"mendmix.security");
    private String keyPrefix;
    private Duration timeToLiveSeconds;

    public RedisCache(String keyPrefix, int timeToLiveSeconds) {
        this.keyPrefix = keyPrefix + ":";
        this.timeToLiveSeconds = Duration.ofSeconds(timeToLiveSeconds);
    }

    private String buildKey(String key) {
        return this.keyPrefix.concat(key);
    }

    @Override
    public void setString(String key, String value) {
        this.stringRedisTemplate.opsForValue().set((Object)this.buildKey(key), (Object)value, this.timeToLiveSeconds);
    }

    @Override
    public String getString(String key) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)this.buildKey(key));
    }

    @Override
    public void setObject(String key, Object value) {
        this.redisTemplate.opsForValue().set((Object)this.buildKey(key), value, this.timeToLiveSeconds);
    }

    @Override
    public <T> T getObject(String key) {
        return (T)this.redisTemplate.opsForValue().get((Object)this.buildKey(key));
    }

    @Override
    public void remove(String key) {
        this.redisTemplate.delete((Object)this.buildKey(key));
    }

    @Override
    public void removeAll() {
    }

    @Override
    public boolean exists(String key) {
        return this.redisTemplate.hasKey((Object)this.buildKey(key));
    }

    @Override
    public void setMapValue(String key, String field, Object value) {
        key = this.buildKey(key);
        this.redisTemplate.opsForHash().put((Object)key, (Object)field, value);
        this.redisTemplate.expire((Object)key, this.timeToLiveSeconds);
    }

    @Override
    public <T> T getMapValue(String key, String field) {
        return (T)this.redisTemplate.opsForHash().get((Object)this.buildKey(key), (Object)field);
    }

    @Override
    public void updateExpireTime(String key) {
        this.redisTemplate.expire((Object)this.buildKey(key), this.timeToLiveSeconds);
    }
}

