/*
 * Decompiled with CFR 0.152.
 */
package com.mendmix.security.cache;

import com.google.common.cache.CacheBuilder;
import com.mendmix.security.Cache;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class LocalCache
implements Cache {
    private com.google.common.cache.Cache<String, Object> cache;

    public LocalCache(int timeToLiveSeconds) {
        this.cache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite((long)timeToLiveSeconds, TimeUnit.SECONDS).build();
    }

    @Override
    public void setString(String key, String value) {
        this.cache.put((Object)key, (Object)value);
    }

    @Override
    public String getString(String key) {
        return Objects.toString(this.getObject(key), null);
    }

    @Override
    public void setObject(String key, Object value) {
        this.cache.put((Object)key, value);
    }

    @Override
    public <T> T getObject(String key) {
        return (T)this.cache.getIfPresent((Object)key);
    }

    @Override
    public void remove(String key) {
        this.cache.invalidate((Object)key);
    }

    @Override
    public boolean exists(String key) {
        return this.cache.getIfPresent((Object)key) != null;
    }

    @Override
    public void removeAll() {
        this.cache.invalidateAll();
    }

    @Override
    public void setMapValue(String key, String field, Object value) {
        HashMap<String, Object> map = (HashMap<String, Object>)this.getObject(key);
        if (map == null) {
            map = new HashMap<String, Object>(1);
            this.setObject(key, map);
        }
        map.put(field, value);
    }

    @Override
    public <T> T getMapValue(String key, String field) {
        Map map = (Map)this.getObject(key);
        if (map == null) {
            return null;
        }
        return (T)map.get(field);
    }

    @Override
    public void updateExpireTime(String key) {
    }
}

